/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random.randomizers.range;

import org.jeasy.random.randomizers.range.AbstractRangeRandomizer;

public class FloatRangeRandomizer
extends AbstractRangeRandomizer<Float> {
    public FloatRangeRandomizer(Float min, Float max) {
        super(min, max);
    }

    public FloatRangeRandomizer(Float min, Float max, long seed) {
        super(min, max, seed);
    }

    @Override
    protected void checkValues() {
        if (((Float)this.min).floatValue() > ((Float)this.max).floatValue()) {
            throw new IllegalArgumentException("max must be greater than min");
        }
    }

    @Override
    protected Float getDefaultMinValue() {
        return Float.valueOf(Float.MIN_VALUE);
    }

    @Override
    protected Float getDefaultMaxValue() {
        return Float.valueOf(Float.MAX_VALUE);
    }

    @Override
    public Float getRandomValue() {
        return Float.valueOf((float)this.nextDouble(((Float)this.min).floatValue(), ((Float)this.max).floatValue()));
    }
}

