/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random.randomizers;

import java.util.Random;
import java.util.ResourceBundle;
import org.jeasy.random.api.Randomizer;

public abstract class AbstractRandomizer<T>
implements Randomizer<T> {
    protected final Random random;

    protected AbstractRandomizer() {
        this.random = new Random();
    }

    protected AbstractRandomizer(long seed) {
        this.random = new Random(seed);
    }

    protected String[] getPredefinedValuesOf(String key) {
        return ResourceBundle.getBundle("easy-random-data").getString(key).split(",");
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    protected double nextDouble(double min, double max) {
        double value = min + this.random.nextDouble() * (max - min);
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }
}

