/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random;

import java.lang.annotation.Annotation;
import java.util.function.Predicate;

public class TypePredicates {
    public static Predicate<Class<?>> named(String name) {
        return clazz -> clazz.getName().equals(name);
    }

    public static Predicate<Class<?>> ofType(Class<?> type) {
        return clazz -> clazz.equals(type);
    }

    public static Predicate<Class<?>> inPackage(String packageNamePrefix) {
        return clazz -> clazz.getPackage().getName().startsWith(packageNamePrefix);
    }

    public static Predicate<Class<?>> isAnnotatedWith(Class<? extends Annotation> ... annotations) {
        return clazz -> {
            for (Class annotation : annotations) {
                if (!clazz.isAnnotationPresent(annotation)) continue;
                return true;
            }
            return false;
        };
    }

    public static Predicate<Class<?>> isInterface() {
        return Class::isInterface;
    }

    public static Predicate<Class<?>> isPrimitive() {
        return Class::isPrimitive;
    }

    public static Predicate<Class<?>> isAbstract() {
        return TypePredicates.hasModifiers(1024);
    }

    public static Predicate<Class<?>> hasModifiers(Integer modifiers) {
        return clazz -> (modifiers & clazz.getModifiers()) == modifiers;
    }

    public static Predicate<Class<?>> isEnum() {
        return Class::isEnum;
    }

    public static Predicate<Class<?>> isArray() {
        return Class::isArray;
    }

    public static Predicate<Class<?>> isAssignableFrom(Class<?> type) {
        return clazz -> clazz.isAssignableFrom(type);
    }
}

