/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl.model.xml;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.jbpm.services.task.impl.model.xml.JaxbPeopleAssignments;
import org.jbpm.services.task.impl.model.xml.JaxbTaskData;
import org.jbpm.services.task.impl.model.xml.adapter.I18NTextXmlAdapter;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.PeopleAssignments;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskData;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.model.InternalI18NText;
import org.kie.internal.task.api.model.InternalOrganizationalEntity;
import org.kie.internal.task.api.model.InternalPeopleAssignments;
import org.kie.internal.task.api.model.InternalTask;
import org.kie.internal.task.api.model.InternalTaskData;

@XmlRootElement(name="task")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class JaxbTask
implements Task {
    @XmlElement
    @XmlSchemaType(name="long")
    private Long id;
    @XmlElement
    @XmlSchemaType(name="long")
    private Integer priority;
    @XmlElement(name="task-type")
    @XmlSchemaType(name="int")
    private String taskType;
    @XmlElement(name="name")
    @XmlJavaTypeAdapter(value=I18NTextXmlAdapter.class)
    private List<I18NText> names;
    @XmlElement(name="subject")
    @XmlJavaTypeAdapter(value=I18NTextXmlAdapter.class)
    private List<I18NText> subjects;
    @XmlElement(name="description")
    @XmlJavaTypeAdapter(value=I18NTextXmlAdapter.class)
    private List<I18NText> descriptions;
    @XmlElement
    private JaxbPeopleAssignments peopleAssignments;
    @XmlElement
    private JaxbTaskData taskData;

    public JaxbTask() {
    }

    public JaxbTask(Task task) {
        this.initialize(task);
    }

    public void initialize(Task task) {
        if (task == null) {
            return;
        }
        this.id = task.getId();
        this.priority = task.getPriority();
        this.peopleAssignments = new JaxbPeopleAssignments(task.getPeopleAssignments());
        this.names = task.getNames();
        this.names.toArray();
        this.subjects = task.getSubjects();
        this.subjects.toArray();
        this.descriptions = task.getDescriptions();
        this.descriptions.toArray();
        this.taskData = new JaxbTaskData(task.getTaskData());
        this.taskType = task.getTaskType();
    }

    public Long getId() {
        return this.id;
    }

    public int getPriority() {
        return this.priority;
    }

    public List<I18NText> getNames() {
        if (this.names == null) {
            this.names = Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.names);
    }

    public List<I18NText> getSubjects() {
        if (this.subjects == null) {
            this.subjects = Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.subjects);
    }

    public List<I18NText> getDescriptions() {
        if (this.descriptions == null) {
            this.descriptions = Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.descriptions);
    }

    public PeopleAssignments getPeopleAssignments() {
        return this.peopleAssignments;
    }

    public TaskData getTaskData() {
        return this.taskData;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public Task getTask() {
        Task taskImpl = TaskModelProvider.getFactory().newTask();
        ArrayList<I18NText> names = new ArrayList<I18NText>();
        for (I18NText n : this.getNames()) {
            I18NText text = TaskModelProvider.getFactory().newI18NText();
            ((InternalI18NText)text).setLanguage(n.getLanguage());
            ((InternalI18NText)text).setText(n.getText());
            names.add(text);
        }
        ((InternalTask)taskImpl).setNames(names);
        ArrayList descriptions = new ArrayList();
        for (I18NText n : this.getDescriptions()) {
            I18NText text = TaskModelProvider.getFactory().newI18NText();
            ((InternalI18NText)text).setLanguage(n.getLanguage());
            ((InternalI18NText)text).setText(n.getText());
            names.add(text);
        }
        ((InternalTask)taskImpl).setDescriptions(descriptions);
        ArrayList subjects = new ArrayList();
        for (I18NText n : this.getSubjects()) {
            I18NText text = TaskModelProvider.getFactory().newI18NText();
            ((InternalI18NText)text).setLanguage(n.getLanguage());
            ((InternalI18NText)text).setText(n.getText());
            names.add(text);
        }
        ((InternalTask)taskImpl).setSubjects(subjects);
        ((InternalTask)taskImpl).setPriority(this.getPriority());
        InternalTaskData taskData = (InternalTaskData)TaskModelProvider.getFactory().newTaskData();
        taskData.setWorkItemId(this.getTaskData().getWorkItemId());
        taskData.setProcessInstanceId(this.getTaskData().getProcessInstanceId());
        taskData.setProcessId(this.getTaskData().getProcessId());
        taskData.setProcessSessionId(this.getTaskData().getProcessSessionId());
        taskData.setSkipable(this.getTaskData().isSkipable());
        PeopleAssignments peopleAssignments = TaskModelProvider.getFactory().newPeopleAssignments();
        ArrayList<Object> potentialOwners = new ArrayList<Object>();
        for (OrganizationalEntity e : this.getPeopleAssignments().getPotentialOwners()) {
            if (e instanceof User) {
                User user = TaskModelProvider.getFactory().newUser();
                ((InternalOrganizationalEntity)user).setId(e.getId());
                potentialOwners.add(user);
                continue;
            }
            if (!(e instanceof Group)) continue;
            Group group = TaskModelProvider.getFactory().newGroup();
            ((InternalOrganizationalEntity)group).setId(e.getId());
            potentialOwners.add(group);
        }
        ((InternalPeopleAssignments)peopleAssignments).setPotentialOwners(potentialOwners);
        ArrayList<Object> businessAdmins = new ArrayList<Object>();
        for (OrganizationalEntity e : this.getPeopleAssignments().getBusinessAdministrators()) {
            if (e instanceof User) {
                User user = TaskModelProvider.getFactory().newUser();
                ((InternalOrganizationalEntity)user).setId(e.getId());
                businessAdmins.add(user);
                continue;
            }
            if (!(e instanceof Group)) continue;
            Group group = TaskModelProvider.getFactory().newGroup();
            ((InternalOrganizationalEntity)group).setId(e.getId());
            businessAdmins.add(group);
        }
        if (this.getPeopleAssignments().getTaskInitiator() != null) {
            User user = TaskModelProvider.getFactory().newUser();
            ((InternalOrganizationalEntity)user).setId(this.getPeopleAssignments().getTaskInitiator().getId());
            ((InternalPeopleAssignments)peopleAssignments).setTaskInitiator(user);
        }
        ((InternalPeopleAssignments)peopleAssignments).setBusinessAdministrators(businessAdmins);
        ((InternalPeopleAssignments)peopleAssignments).setExcludedOwners(new ArrayList());
        ((InternalPeopleAssignments)peopleAssignments).setRecipients(new ArrayList());
        ((InternalPeopleAssignments)peopleAssignments).setTaskStakeholders(new ArrayList());
        ((InternalTask)taskImpl).setPeopleAssignments(peopleAssignments);
        ((InternalTask)taskImpl).setTaskData((TaskData)taskData);
        return taskImpl;
    }

    public void readExternal(ObjectInput arg0) throws IOException, ClassNotFoundException {
        String methodName = new Throwable().getStackTrace()[0].getMethodName();
        throw new UnsupportedOperationException(methodName + " is not supported on the JAXB " + Task.class.getSimpleName() + " implementation.");
    }

    public void writeExternal(ObjectOutput arg0) throws IOException {
        String methodName = new Throwable().getStackTrace()[0].getMethodName();
        throw new UnsupportedOperationException(methodName + " is not supported on the JAXB " + Task.class.getSimpleName() + " implementation.");
    }
}

