/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedCallable;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.lang.model.AnnotationInfo;
import jakarta.enterprise.lang.model.declarations.DeclarationInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.weld.lite.extension.translator.AnnotationInfoImpl;
import org.jboss.weld.lite.extension.translator.AnnotationTargetImpl;
import org.jboss.weld.lite.extension.translator.ClassInfoImpl;
import org.jboss.weld.lite.extension.translator.FieldInfoImpl;
import org.jboss.weld.lite.extension.translator.MethodInfoImpl;
import org.jboss.weld.lite.extension.translator.ParameterInfoImpl;
import org.jboss.weld.lite.extension.translator.logging.LiteExtensionTranslatorLogger;

abstract class DeclarationInfoImpl<ReflectionDeclaration extends AnnotatedElement, CdiDeclaration extends Annotated>
extends AnnotationTargetImpl<ReflectionDeclaration>
implements DeclarationInfo {
    final CdiDeclaration cdiDeclaration;

    DeclarationInfoImpl(ReflectionDeclaration reflectionDeclaration, CdiDeclaration cdiDeclaration, BeanManager bm) {
        super(reflectionDeclaration, null, bm);
        this.cdiDeclaration = cdiDeclaration;
    }

    static DeclarationInfo fromCdiDeclaration(Annotated cdiDeclaration, BeanManager bm) {
        Objects.requireNonNull(cdiDeclaration);
        if (cdiDeclaration instanceof AnnotatedType) {
            return new ClassInfoImpl((AnnotatedType)cdiDeclaration, bm);
        }
        if (cdiDeclaration instanceof AnnotatedCallable) {
            return new MethodInfoImpl((AnnotatedCallable)cdiDeclaration, bm);
        }
        if (cdiDeclaration instanceof AnnotatedParameter) {
            return new ParameterInfoImpl((AnnotatedParameter)cdiDeclaration, bm);
        }
        if (cdiDeclaration instanceof AnnotatedField) {
            return new FieldInfoImpl((AnnotatedField)cdiDeclaration, bm);
        }
        throw LiteExtensionTranslatorLogger.LOG.unknownDeclaration(cdiDeclaration);
    }

    @Override
    public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
        if (this.cdiDeclaration == null) {
            return super.hasAnnotation(annotationType);
        }
        return this.cdiDeclaration.isAnnotationPresent(annotationType);
    }

    @Override
    public boolean hasAnnotation(Predicate<AnnotationInfo> predicate) {
        if (this.cdiDeclaration == null) {
            return super.hasAnnotation(predicate);
        }
        return this.cdiDeclaration.getAnnotations().stream().anyMatch(it -> predicate.test(new AnnotationInfoImpl((Annotation)it, this.bm)));
    }

    @Override
    public <T extends Annotation> AnnotationInfo annotation(Class<T> annotationType) {
        if (this.cdiDeclaration == null) {
            return super.annotation(annotationType);
        }
        T annotation = this.cdiDeclaration.getAnnotation(annotationType);
        return annotation == null ? null : new AnnotationInfoImpl((Annotation)annotation, this.bm);
    }

    @Override
    public <T extends Annotation> Collection<AnnotationInfo> repeatableAnnotation(Class<T> annotationType) {
        if (this.cdiDeclaration == null) {
            return super.repeatableAnnotation(annotationType);
        }
        return this.cdiDeclaration.getAnnotations(annotationType).stream().map(t -> new AnnotationInfoImpl((Annotation)t, this.bm)).collect(Collectors.toList());
    }

    @Override
    public Collection<AnnotationInfo> annotations(Predicate<AnnotationInfo> predicate) {
        if (this.cdiDeclaration == null) {
            return super.annotations(predicate);
        }
        return this.cdiDeclaration.getAnnotations().stream().map(annotation -> new AnnotationInfoImpl((Annotation)annotation, this.bm)).filter(predicate).collect(Collectors.toList());
    }

    public String toString() {
        return this.cdiDeclaration != null ? this.cdiDeclaration.toString() : this.reflection.toString();
    }
}

