/*
 * JBoss, Home of Professional Open Source
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.shrinkwrap.impl.base.spec;

import java.util.logging.Logger;

import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.base.container.WebContainerBase;

/**
 * WebArchiveImpl
 *
 * @author <a href="mailto:aslak@conduct.no">Aslak Knutsen</a>
 * @version $Revision: $
 */
public class WebArchiveImpl extends WebContainerBase<WebArchive> implements WebArchive
{
   //-------------------------------------------------------------------------------------||
   // Class Members ----------------------------------------------------------------------||
   //-------------------------------------------------------------------------------------||

   @SuppressWarnings("unused")
   private static final Logger log = Logger.getLogger(WebArchiveImpl.class.getName());

   /**
    * Path to the web inside of the Archive.
    */
   private static final ArchivePath PATH_WEB = ArchivePaths.root();

   /**
    * Path to the WEB-INF inside of the Archive.
    */
   private static final ArchivePath PATH_WEB_INF = ArchivePaths.create("WEB-INF");

   /**
    * Path to the resources inside of the Archive.
    */
   private static final ArchivePath PATH_RESOURCE = ArchivePaths.create(PATH_WEB_INF, "classes");

   /**
    * Path to the libraries inside of the Archive.
    */
   private static final ArchivePath PATH_LIBRARY = ArchivePaths.create(PATH_WEB_INF, "lib");

   /**
    * Path to the classes inside of the Archive.
    */
   private static final ArchivePath PATH_CLASSES = ArchivePaths.create(PATH_WEB_INF, "classes");

   /**
    * Path to the manifests inside of the Archive.
    */
   private static final ArchivePath PATH_MANIFEST = ArchivePaths.create("META-INF");

   /**
    * Path to web archive service providers.
    */
   private static final ArchivePath PATH_SERVICE_PROVIDERS = ArchivePaths.create(PATH_CLASSES, "META-INF/services");

   //-------------------------------------------------------------------------------------||
   // Instance Members -------------------------------------------------------------------||
   //-------------------------------------------------------------------------------------||

   //-------------------------------------------------------------------------------------||
   // Constructor ------------------------------------------------------------------------||
   //-------------------------------------------------------------------------------------||

   /**
    * Create a new WebArchive with any type storage engine as backing.
    * 
    * @param delegate The storage backing.
    */
   public WebArchiveImpl(final Archive<?> delegate)
   {
      super(WebArchive.class, delegate);
   }

   //-------------------------------------------------------------------------------------||
   // Required Implementations -----------------------------------------------------------||
   //-------------------------------------------------------------------------------------||

   /**
    * {@inheritDoc}
    * @see org.jboss.shrinkwrap.impl.base.container.ContainerBase#getManifestPath()
    */
   @Override
   protected ArchivePath getManifestPath()
   {
      return PATH_MANIFEST;
   }

   /**
    * {@inheritDoc}
    * @see org.jboss.shrinkwrap.impl.base.container.ContainerBase#getClassesPath()
    */
   @Override
   protected ArchivePath getClassesPath()
   {
      return PATH_CLASSES;
   }

   /**
    * {@inheritDoc}
    * @see org.jboss.shrinkwrap.impl.base.container.ContainerBase#getResourcePath()
    */
   @Override
   protected ArchivePath getResourcePath()
   {
      return PATH_RESOURCE;
   }

   /**
    * {@inheritDoc}
    * @see org.jboss.shrinkwrap.impl.base.container.ContainerBase#getLibraryPath()
    */
   @Override
   protected ArchivePath getLibraryPath()
   {
      return PATH_LIBRARY;
   }

   /**
    * {@inheritDoc}
    * @see org.jboss.shrinkwrap.impl.base.container.WebContainerBase#getWebPath()
    */
   @Override
   protected ArchivePath getWebPath()
   {
      return PATH_WEB;
   }

   /**
    * {@inheritDoc}
    * @see org.jboss.shrinkwrap.impl.base.container.WebContainerBase#getWebInfPath()
    */
   @Override
   protected ArchivePath getWebInfPath()
   {
      return PATH_WEB_INF;
   }

   /**
    * {@inheritDoc}
    * @see org.jboss.shrinkwrap.impl.base.container.WebContainerBase#getWebInfPath()
    */
   @Override
   protected ArchivePath getServiceProvidersPath()
   {
      return PATH_SERVICE_PROVIDERS;
   }
}
