/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.container;

import java.io.File;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Map;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.jboss.shrinkwrap.api.asset.NamedAsset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.container.ClassContainer;
import org.jboss.shrinkwrap.api.container.LibraryContainer;
import org.jboss.shrinkwrap.api.container.ManifestContainer;
import org.jboss.shrinkwrap.api.container.ResourceContainer;
import org.jboss.shrinkwrap.api.exporter.StreamExporter;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.formatter.Formatter;
import org.jboss.shrinkwrap.impl.base.ArchiveBase;
import org.jboss.shrinkwrap.impl.base.AssignableBase;
import org.jboss.shrinkwrap.impl.base.URLPackageScanner;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.asset.AssetUtil;
import org.jboss.shrinkwrap.impl.base.asset.ClassAsset;
import org.jboss.shrinkwrap.impl.base.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.impl.base.asset.ServiceProviderAsset;
import org.jboss.shrinkwrap.impl.base.container.SecurityActions;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContainerBase<T extends Archive<T>>
extends AssignableBase<Archive<?>>
implements Archive<T>,
ManifestContainer<T>,
ResourceContainer<T>,
ClassContainer<T>,
LibraryContainer<T> {
    private static final Archive<?>[] CAST = new Archive[0];
    private final Class<T> actualType;

    protected ContainerBase(Class<T> actualType, Archive<?> archive) {
        super(archive);
        Validate.notNull(actualType, "ActualType should be specified");
        this.actualType = actualType;
    }

    public T add(Archive<?> archive, String path, Class<? extends StreamExporter> exporter) {
        this.getArchive().add(archive, path, exporter);
        return this.covarientReturn();
    }

    public T add(Archive<?> archive, ArchivePath path, Class<? extends StreamExporter> exporter) {
        this.getArchive().add(archive, path, exporter);
        return this.covarientReturn();
    }

    public T add(Asset asset, ArchivePath target) throws IllegalArgumentException {
        this.getArchive().add(asset, target);
        return this.covarientReturn();
    }

    public T add(Asset asset, ArchivePath path, String name) {
        this.getArchive().add(asset, path, name);
        return this.covarientReturn();
    }

    public T add(Asset asset, String target, String name) throws IllegalArgumentException {
        this.getArchive().add(asset, target, name);
        return this.covarientReturn();
    }

    public T add(NamedAsset namedAsset) {
        this.getArchive().add(namedAsset);
        return this.covarientReturn();
    }

    public T addDirectories(ArchivePath ... paths) throws IllegalArgumentException {
        this.getArchive().addDirectories(paths);
        return this.covarientReturn();
    }

    public T addDirectories(String ... paths) throws IllegalArgumentException {
        this.getArchive().addDirectories(paths);
        return this.covarientReturn();
    }

    public T addDirectory(ArchivePath path) throws IllegalArgumentException {
        this.getArchive().addDirectory(path);
        return this.covarientReturn();
    }

    public T addDirectory(String path) throws IllegalArgumentException {
        this.getArchive().addDirectory(path);
        return this.covarientReturn();
    }

    public T merge(Archive<?> source) throws IllegalArgumentException {
        this.getArchive().merge(source);
        return this.covarientReturn();
    }

    public T merge(Archive<?> source, Filter<ArchivePath> filter) throws IllegalArgumentException {
        this.getArchive().merge(source, filter);
        return this.covarientReturn();
    }

    public T merge(Archive<?> source, ArchivePath path) throws IllegalArgumentException {
        this.getArchive().merge(source, path);
        return this.covarientReturn();
    }

    public T merge(Archive<?> source, ArchivePath path, Filter<ArchivePath> filter) throws IllegalArgumentException {
        this.getArchive().merge(source, path, filter);
        return this.covarientReturn();
    }

    public T merge(Archive<?> source, String path, Filter<ArchivePath> filter) throws IllegalArgumentException {
        this.getArchive().merge(source, path, filter);
        return this.covarientReturn();
    }

    public T merge(Archive<?> source, String path) throws IllegalArgumentException {
        this.getArchive().merge(source, path);
        return this.covarientReturn();
    }

    public T add(Asset asset, String name) {
        this.getArchive().add(asset, name);
        return this.covarientReturn();
    }

    public boolean contains(ArchivePath path) {
        return this.getArchive().contains(path);
    }

    public boolean contains(String path) throws IllegalArgumentException {
        Validate.notNull(path, "Path must be specified");
        return this.contains(ArchivePaths.create((String)path));
    }

    public Node delete(ArchivePath path) {
        return this.getArchive().delete(path);
    }

    public Node get(ArchivePath path) {
        return this.getArchive().get(path);
    }

    public Node get(String path) throws IllegalArgumentException {
        return this.getArchive().get(path);
    }

    public <X extends Archive<X>> X getAsType(Class<X> type, String path) {
        return (X)this.getArchive().getAsType(type, path);
    }

    public <X extends Archive<X>> X getAsType(Class<X> type, ArchivePath path) {
        return (X)this.getArchive().getAsType(type, path);
    }

    public <X extends Archive<X>> Collection<X> getAsType(Class<X> type, Filter<ArchivePath> filter) {
        return this.getArchive().getAsType(type, filter);
    }

    public Map<ArchivePath, Node> getContent() {
        return this.getArchive().getContent();
    }

    public Map<ArchivePath, Node> getContent(Filter<ArchivePath> filter) {
        return this.getArchive().getContent(filter);
    }

    public String getName() {
        return this.getArchive().getName();
    }

    public String toString() {
        return this.getArchive().toString();
    }

    public String toString(boolean verbose) {
        return this.getArchive().toString(verbose);
    }

    public String toString(Formatter formatter) throws IllegalArgumentException {
        return this.getArchive().toString(formatter);
    }

    public int hashCode() {
        return this.getArchive().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ArchiveBase) {
            return this.getArchive().equals(obj);
        }
        if (!(obj instanceof ContainerBase)) {
            return false;
        }
        ContainerBase other = (ContainerBase)obj;
        return this.getArchive().equals(other.getArchive());
    }

    protected abstract ArchivePath getManifestPath();

    public final T setManifest(String resourceName) {
        Validate.notNull(resourceName, "ResourceName should be specified");
        return this.setManifest(new ClassLoaderAsset(resourceName));
    }

    public T setManifest(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        return this.setManifest((Asset)new FileAsset(resource));
    }

    public T setManifest(URL resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        return this.setManifest((Asset)new UrlAsset(resource));
    }

    public T setManifest(Asset resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        return this.addAsManifestResource(resource, "MANIFEST.MF");
    }

    public final T addAsManifestResource(String resourceName) {
        Validate.notNull(resourceName, "ResourceName should be specified");
        return this.addAsManifestResource((Asset)new ClassLoaderAsset(resourceName), resourceName);
    }

    public T addAsManifestResource(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        return this.addAsManifestResource((Asset)new FileAsset(resource), resource.getName());
    }

    public T addAsManifestResource(String resourceName, String target) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addAsManifestResource((Asset)new ClassLoaderAsset(resourceName), target);
    }

    public T addAsManifestResource(File resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addAsManifestResource((Asset)new FileAsset(resource), target);
    }

    public T addAsManifestResource(URL resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addAsManifestResource((Asset)new UrlAsset(resource), target);
    }

    public T addAsManifestResource(Asset resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addAsManifestResource(resource, (ArchivePath)new BasicPath(target));
    }

    public T addAsManifestResource(String resourceName, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addAsManifestResource((Asset)new ClassLoaderAsset(resourceName), target);
    }

    public T addAsManifestResource(File resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addAsManifestResource((Asset)new FileAsset(resource), target);
    }

    public T addAsManifestResource(URL resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addAsManifestResource((Asset)new UrlAsset(resource), target);
    }

    public T addAsManifestResource(Asset resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        BasicPath location = new BasicPath(this.getManifestPath(), target);
        return this.add(resource, location);
    }

    public T addAsManifestResources(Package resourcePackage, String ... resourceNames) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNullAndNoNullValues(resourceNames, "ResourceNames must be specified and can not container null values");
        for (String resourceName : resourceNames) {
            this.addAsManifestResource(resourcePackage, resourceName);
        }
        return this.covarientReturn();
    }

    public T addAsManifestResource(Package resourcePackage, String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        String classloaderResourceName = AssetUtil.getClassLoaderResourceName(resourcePackage, resourceName);
        ArchivePath target = ArchivePaths.create((String)classloaderResourceName);
        return this.addAsManifestResource(resourcePackage, resourceName, target);
    }

    public T addAsManifestResource(Package resourcePackage, String resourceName, String target) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addAsManifestResource(resourcePackage, resourceName, ArchivePaths.create((String)target));
    }

    public T addAsManifestResource(Package resourcePackage, String resourceName, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        Validate.notNull(target, "Target must be specified");
        String classloaderResourceName = AssetUtil.getClassLoaderResourceName(resourcePackage, resourceName);
        ClassLoaderAsset resource = new ClassLoaderAsset(classloaderResourceName);
        return this.addAsManifestResource((Asset)resource, target);
    }

    public T addAsServiceProvider(Class<?> serviceInterface, Class<?> ... serviceImpls) throws IllegalArgumentException {
        Validate.notNull(serviceInterface, "ServiceInterface must be specified");
        Validate.notNullAndNoNullValues(serviceImpls, "ServiceImpls must be specified and can not contain null values");
        ServiceProviderAsset asset = new ServiceProviderAsset(serviceImpls);
        BasicPath path = new BasicPath("services", serviceInterface.getName());
        return this.addAsManifestResource((Asset)asset, (ArchivePath)path);
    }

    protected abstract ArchivePath getResourcePath();

    public final T addAsResource(String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName should be specified");
        return this.addAsResource((Asset)new ClassLoaderAsset(resourceName), resourceName);
    }

    public final T addAsResource(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        return this.addAsResource((Asset)new FileAsset(resource), resource.getName());
    }

    public final T addAsResource(String resourceName, String target) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addAsResource((Asset)new ClassLoaderAsset(resourceName), target);
    }

    public T addAsResource(File resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addAsResource((Asset)new FileAsset(resource), target);
    }

    public T addAsResource(URL resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addAsResource((Asset)new UrlAsset(resource), target);
    }

    public T addAsResource(Asset resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addAsResource(resource, (ArchivePath)new BasicPath(target));
    }

    public T addAsResource(String resourceName, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addAsResource((Asset)new ClassLoaderAsset(resourceName), target);
    }

    public T addAsResource(String resourceName, ArchivePath target, ClassLoader classLoader) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName should be specified");
        Validate.notNull(target, "Target should be specified");
        Validate.notNull(classLoader, "ClassLoader should be specified");
        return this.addAsResource((Asset)new ClassLoaderAsset(resourceName, classLoader), target);
    }

    public T addAsResource(File resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addAsResource((Asset)new FileAsset(resource), target);
    }

    public T addAsResource(URL resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addAsResource((Asset)new UrlAsset(resource), target);
    }

    public T addAsResource(Asset resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        BasicPath location = new BasicPath(this.getResourcePath(), target);
        return this.add(resource, location);
    }

    public T addAsResources(Package resourcePackage, String ... resourceNames) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNullAndNoNullValues(resourceNames, "ResourceNames must be specified and can not container null values");
        for (String resourceName : resourceNames) {
            this.addAsResource(resourcePackage, resourceName);
        }
        return this.covarientReturn();
    }

    public T addAsResource(Package resourcePackage, String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        String classloaderResourceName = AssetUtil.getClassLoaderResourceName(resourcePackage, resourceName);
        ArchivePath target = ArchivePaths.create((String)classloaderResourceName);
        return this.addAsResource(resourcePackage, resourceName, target);
    }

    public T addAsResource(Package resourcePackage, String resourceName, String target) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addAsResource(resourcePackage, resourceName, ArchivePaths.create((String)target));
    }

    public T addAsResource(Package resourcePackage, String resourceName, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        Validate.notNull(target, "Target must be specified");
        String classloaderResourceName = AssetUtil.getClassLoaderResourceName(resourcePackage, resourceName);
        ClassLoaderAsset resource = new ClassLoaderAsset(classloaderResourceName);
        return this.addAsResource((Asset)resource, target);
    }

    protected abstract ArchivePath getClassesPath();

    public T addClass(Class<?> clazz) throws IllegalArgumentException {
        Validate.notNull(clazz, "Clazz must be specified");
        return this.addClasses(clazz);
    }

    public T addClass(String fullyQualifiedClassName) throws IllegalArgumentException {
        Validate.notNullOrEmpty(fullyQualifiedClassName, "Fully-qualified class name must be specified");
        return this.addClass(fullyQualifiedClassName, AccessController.doPrivileged(GetTcclAction.INSTANCE));
    }

    public T addClass(String fullyQualifiedClassName, ClassLoader cl) throws IllegalArgumentException {
        Class<?> clazz;
        Validate.notNullOrEmpty(fullyQualifiedClassName, "Fully-qualified class name must be specified");
        Validate.notNull(cl, "ClassLoader must be specified");
        try {
            clazz = Class.forName(fullyQualifiedClassName, false, cl);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not load class of name " + fullyQualifiedClassName + " with " + cl, e);
        }
        return this.addClass(clazz);
    }

    public T addClasses(Class<?> ... classes) throws IllegalArgumentException {
        Validate.notNull(classes, "Classes must be specified");
        for (final Class<?> clazz : classes) {
            ClassAsset resource = new ClassAsset(clazz);
            BasicPath location = new BasicPath(this.getClassesPath(), AssetUtil.getFullPathForClassResource(clazz));
            this.add((Asset)resource, location);
            this.addPackages(false, new Filter<ArchivePath>(){

                public boolean include(ArchivePath path) {
                    ArchivePath classArchivePath = AssetUtil.getFullPathForClassResource(clazz);
                    String expression = classArchivePath.get().replace(".class", "\\$.*");
                    return path.get().matches(expression);
                }
            }, clazz.getPackage());
        }
        return this.covarientReturn();
    }

    public T addPackage(Package pack) throws IllegalArgumentException {
        Validate.notNull(pack, "Pack must be specified");
        return this.addPackage(pack.getName());
    }

    public T addPackages(boolean recursive, Package ... packages) throws IllegalArgumentException {
        Validate.notNull(packages, "Packages must be specified");
        return this.addPackages(recursive, (Filter<ArchivePath>)Filters.includeAll(), packages);
    }

    public T addPackages(boolean recursive, Filter<ArchivePath> filter, Package ... packages) throws IllegalArgumentException {
        Validate.notNull(filter, "Filter must be specified");
        Validate.notNull(packages, "Packages must be specified");
        String[] packageNames = new String[packages.length];
        for (int i = 0; i < packages.length; ++i) {
            packageNames[i] = packages[i] == null ? null : packages[i].getName();
        }
        return this.addPackages(recursive, filter, packageNames);
    }

    public T addPackage(String pack) throws IllegalArgumentException {
        Validate.notNull(pack, "Package must be specified");
        return this.addPackages(false, pack);
    }

    public T addPackages(boolean recursive, String ... packages) throws IllegalArgumentException {
        Validate.notNullAndNoNullValues(packages, "Pakcages must be specified and can not container null values");
        return this.addPackages(recursive, (Filter<ArchivePath>)Filters.includeAll(), packages);
    }

    public T addPackages(boolean recursive, final Filter<ArchivePath> filter, String ... packageNames) throws IllegalArgumentException {
        Validate.notNull(filter, "Filter must be specified");
        Validate.notNull(packageNames, "PackageNames must be specified");
        final ClassLoader classLoader = SecurityActions.getThreadContextClassLoader();
        for (String packageName : packageNames) {
            URLPackageScanner.Callback callback = new URLPackageScanner.Callback(){

                public void classFound(String className) {
                    ArchivePath classNamePath = AssetUtil.getFullPathForClassResource(className);
                    if (!filter.include((Object)classNamePath)) {
                        return;
                    }
                    ClassLoaderAsset asset = new ClassLoaderAsset(classNamePath.get().substring(1), classLoader);
                    BasicPath location = new BasicPath(ContainerBase.this.getClassesPath(), classNamePath);
                    ContainerBase.this.add((Asset)asset, location);
                }
            };
            URLPackageScanner scanner = packageName == null ? URLPackageScanner.newInstance(recursive, classLoader, callback) : URLPackageScanner.newInstance(recursive, classLoader, callback, packageName);
            scanner.scanPackage();
        }
        return this.covarientReturn();
    }

    protected abstract ArchivePath getLibraryPath();

    public T addAsLibrary(Archive<?> archive) throws IllegalArgumentException {
        Validate.notNull(archive, "Archive must be specified");
        return this.add(archive, this.getLibraryPath(), ZipExporter.class);
    }

    public T addAsLibrary(String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName must be specified");
        return this.addAsLibrary((Asset)new ClassLoaderAsset(resourceName), resourceName);
    }

    public T addAsLibrary(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        return this.addAsLibrary((Asset)new FileAsset(resource), resource.getName());
    }

    public T addAsLibrary(String resourceName, String target) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addAsLibrary((Asset)new ClassLoaderAsset(resourceName), target);
    }

    public T addAsLibrary(File resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addAsLibrary((Asset)new FileAsset(resource), target);
    }

    public T addAsLibrary(URL resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addAsLibrary((Asset)new UrlAsset(resource), target);
    }

    public T addAsLibrary(Asset resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addAsLibrary(resource, (ArchivePath)new BasicPath(target));
    }

    public T addAsLibrary(String resourceName, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addAsLibrary((Asset)new ClassLoaderAsset(resourceName), target);
    }

    public T addAsLibrary(File resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addAsLibrary((Asset)new FileAsset(resource), target);
    }

    public T addAsLibrary(URL resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addAsLibrary((Asset)new UrlAsset(resource), target);
    }

    public T addAsLibrary(Asset resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        BasicPath location = new BasicPath(this.getLibraryPath(), target);
        return this.add(resource, location);
    }

    public T addAsLibraries(String ... resourceNames) throws IllegalArgumentException {
        Validate.notNull(resourceNames, "ResourceNames must be specified");
        for (String resourceName : resourceNames) {
            this.addAsLibrary(resourceName);
        }
        return this.covarientReturn();
    }

    public T addAsLibraries(File ... resources) throws IllegalArgumentException {
        Validate.notNull(resources, "Resources must be specified");
        for (File resource : resources) {
            this.addAsLibrary(resource);
        }
        return this.covarientReturn();
    }

    public T addAsLibraries(Archive<?> ... archives) throws IllegalArgumentException {
        Validate.notNull(archives, "Archives must be specified");
        for (Archive<?> archive : archives) {
            this.addAsLibrary(archive);
        }
        return this.covarientReturn();
    }

    public T addAsLibraries(Collection<? extends Archive<?>> archives) throws IllegalArgumentException {
        Validate.notNull(archives, "Archives must be specified");
        return this.addAsLibraries(archives.toArray(CAST));
    }

    protected T covarientReturn() {
        return (T)((Archive)this.getActualClass().cast(this));
    }

    protected Class<T> getActualClass() {
        return this.actualType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum GetTcclAction implements PrivilegedAction<ClassLoader>
    {
        INSTANCE;


        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

