/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jboss.shrinkwrap.resolver.api.NoResolvedResultException;
import org.jboss.shrinkwrap.resolver.api.NonUniqueResultException;
import org.jboss.shrinkwrap.resolver.api.ResolvedArtifact;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolvedArtifact;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;
import org.jboss.shrinkwrap.resolver.spi.format.FormatProcessor;
import org.jboss.shrinkwrap.resolver.spi.format.FormatProcessors;

public class MavenFormatStageImpl
implements MavenFormatStage {
    private final Collection<MavenResolvedArtifact> artifacts;

    public MavenFormatStageImpl(Collection<MavenResolvedArtifact> artifacts) {
        assert (artifacts != null) : "Artifacts are required";
        this.artifacts = artifacts;
    }

    public File[] asFile() {
        return this.as(File.class);
    }

    public File asSingleFile() throws NonUniqueResultException, NoResolvedResultException {
        return this.asSingle(File.class);
    }

    public InputStream[] asInputStream() {
        return this.as(InputStream.class);
    }

    public InputStream asSingleInputStream() throws NonUniqueResultException, NoResolvedResultException {
        return this.asSingle(InputStream.class);
    }

    public MavenResolvedArtifact[] asResolvedArtifact() {
        return this.as(MavenResolvedArtifact.class);
    }

    public MavenResolvedArtifact asSingleResolvedArtifact() throws NonUniqueResultException, NoResolvedResultException {
        return this.asSingle(MavenResolvedArtifact.class);
    }

    public <RETURNTYPE> RETURNTYPE[] as(Class<RETURNTYPE> returnTypeClass) throws IllegalArgumentException, UnsupportedOperationException {
        Validate.notNull(returnTypeClass, "Return type class must not be null");
        FormatProcessor processor = FormatProcessors.find(MavenResolvedArtifact.class, returnTypeClass);
        Object[] array = (Object[])Array.newInstance(returnTypeClass, this.artifacts.size());
        int i = 0;
        for (MavenResolvedArtifact artifact : this.artifacts) {
            array[i++] = processor.process((ResolvedArtifact)artifact, returnTypeClass);
        }
        return array;
    }

    public <RETURNTYPE> List<RETURNTYPE> asList(Class<RETURNTYPE> returnTypeClass) throws IllegalArgumentException, UnsupportedOperationException {
        return Arrays.asList(this.as(returnTypeClass));
    }

    public <RETURNTYPE> RETURNTYPE asSingle(Class<RETURNTYPE> type) throws IllegalArgumentException, UnsupportedOperationException, NonUniqueResultException, NoResolvedResultException {
        return this.getSingle(this.as(type));
    }

    private <RETURNTYPE> RETURNTYPE getSingle(RETURNTYPE[] array) throws IllegalArgumentException, NoResolvedResultException, NonUniqueResultException {
        Validate.notNull(array, "Array must not be null");
        if (array.length == 0) {
            throw new NoResolvedResultException("Unable to resolve dependencies, none of them were found.");
        }
        if (array.length != 1) {
            StringBuilder sb = new StringBuilder();
            for (RETURNTYPE artifact : array) {
                sb.append(artifact).append("\n");
            }
            if (sb.lastIndexOf("\n") != -1) {
                sb.deleteCharAt(sb.length() - 1);
            }
            throw new NonUniqueResultException(MessageFormat.format("Resolution resolved more than a single artifact ({0} artifact(s)), unable to determine which one should used.\nComplete list of resolved artifacts:\n{1}", array.length, sb));
        }
        return array[0];
    }
}

