/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.delegates;

import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.plugins.delegates.MediaTypeHeaderDelegate;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;

public class SimpleMediaType {
    private String type;
    private String subtype;

    public SimpleMediaType(String type, String subtype) {
        this.type = type == null ? "*" : type;
        this.subtype = subtype == null ? "*" : subtype;
    }

    public SimpleMediaType() {
        this("*", "*");
    }

    public String getType() {
        return this.type;
    }

    public boolean isWildcardType() {
        return this.getType().equals("*");
    }

    public String getSubtype() {
        return this.subtype;
    }

    public boolean isWildcardSubtype() {
        return this.getSubtype().equals("*");
    }

    public boolean isCompatible(MediaType other) {
        return other != null && (this.type.equals("*") || other.getType().equals("*") || this.type.equalsIgnoreCase(other.getType()) && (this.subtype.equals("*") || other.getSubtype().equals("*")) || this.type.equalsIgnoreCase(other.getType()) && this.subtype.equalsIgnoreCase(other.getSubtype()));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SimpleMediaType)) {
            return false;
        }
        SimpleMediaType other = (SimpleMediaType)obj;
        return this.type.equalsIgnoreCase(other.type) && this.subtype.equalsIgnoreCase(other.subtype);
    }

    public int hashCode() {
        return (this.type.toLowerCase() + this.subtype.toLowerCase()).hashCode();
    }

    public static SimpleMediaType valueOf(String type) {
        int typeIndex = type.indexOf(47);
        int paramIndex = type.indexOf(59);
        String major = null;
        String subtype = null;
        if (typeIndex < 0) {
            major = type;
            if (paramIndex > -1) {
                major = major.substring(0, paramIndex);
            }
            if (!"*".equals(major)) {
                throw new IllegalArgumentException(Messages.MESSAGES.failureParsingMediaType(type));
            }
            subtype = "*";
        } else {
            major = type.substring(0, typeIndex);
            subtype = paramIndex > -1 ? type.substring(typeIndex + 1, paramIndex) : type.substring(typeIndex + 1);
        }
        if (major.length() < 1 || subtype.length() < 1) {
            throw new IllegalArgumentException(Messages.MESSAGES.failureParsingMediaType(type));
        }
        if (!MediaTypeHeaderDelegate.isValid(major) || !MediaTypeHeaderDelegate.isValid(subtype)) {
            throw new IllegalArgumentException(Messages.MESSAGES.failureParsingMediaType(type));
        }
        return new SimpleMediaType(type, subtype);
    }
}

