/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.util.Date;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.core.AbstractAsynchronousResponse;
import org.jboss.resteasy.core.AbstractExecutionContext;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyAsynchronousResponse;
import org.jboss.resteasy.spi.UnhandledException;

public class SynchronousExecutionContext
extends AbstractExecutionContext {
    protected final CountDownLatch syncLatch = new CountDownLatch(1);
    protected long timeout;
    protected TimeUnit timeoutUnit = TimeUnit.MILLISECONDS;
    protected boolean wasSuspended;
    protected volatile boolean done;
    protected Object responseLock = new Object();
    protected ResteasyAsynchronousResponse asynchronousResponse;

    public SynchronousExecutionContext(SynchronousDispatcher dispatcher, HttpRequest request, HttpResponse response) {
        super(dispatcher, request, response);
    }

    @Override
    public AsyncResponse suspend() throws IllegalStateException {
        return this.suspend(-1L);
    }

    @Override
    public AsyncResponse suspend(long millis) throws IllegalStateException {
        return this.suspend(millis, TimeUnit.MILLISECONDS);
    }

    @Override
    public AsyncResponse suspend(long time, TimeUnit unit) throws IllegalStateException {
        this.wasSuspended = true;
        this.asynchronousResponse = new SynchronousAsynchronousResponse(this.dispatcher, this.request, this.response);
        this.asynchronousResponse.setTimeout(time, unit);
        return this.asynchronousResponse;
    }

    @Override
    public ResteasyAsynchronousResponse getAsyncResponse() {
        return this.asynchronousResponse;
    }

    @Override
    public boolean isSuspended() {
        return this.wasSuspended;
    }

    protected class SynchronousAsynchronousResponse
    extends AbstractAsynchronousResponse {
        protected boolean cancelled;

        public SynchronousAsynchronousResponse(SynchronousDispatcher dispatcher, HttpRequest request, HttpResponse response) {
            super(dispatcher, request, response);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resume(Object entity) throws IllegalStateException {
            Object object = SynchronousExecutionContext.this.responseLock;
            synchronized (object) {
                if (SynchronousExecutionContext.this.done) {
                    throw new IllegalStateException("Response processing is finished");
                }
                if (this.cancelled) {
                    throw new IllegalStateException("Response processing is cancelled");
                }
                try {
                    super.resume(entity);
                }
                finally {
                    SynchronousExecutionContext.this.done = true;
                    SynchronousExecutionContext.this.syncLatch.countDown();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resume(Throwable exc) throws IllegalStateException {
            Object object = SynchronousExecutionContext.this.responseLock;
            synchronized (object) {
                if (SynchronousExecutionContext.this.done) {
                    throw new IllegalStateException("Response processing is finished");
                }
                if (this.cancelled) {
                    throw new IllegalStateException("Response processing is cancelled");
                }
                try {
                    super.resume(exc);
                }
                finally {
                    SynchronousExecutionContext.this.done = true;
                    SynchronousExecutionContext.this.syncLatch.countDown();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void initialRequestThreadFinished() {
            if (!SynchronousExecutionContext.this.wasSuspended) {
                return;
            }
            boolean result = false;
            try {
                result = SynchronousExecutionContext.this.syncLatch.await(SynchronousExecutionContext.this.timeout, SynchronousExecutionContext.this.timeoutUnit);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!result) {
                Object object = SynchronousExecutionContext.this.responseLock;
                synchronized (object) {
                    if (!SynchronousExecutionContext.this.done) {
                        if (this.timeoutHandler != null) {
                            this.timeoutHandler.handleTimeout((AsyncResponse)this);
                        }
                        if (!SynchronousExecutionContext.this.done) {
                            try {
                                this.sendResponse(Response.status((int)503).build());
                            }
                            catch (Exception e) {
                                throw new UnhandledException(e);
                            }
                            finally {
                                SynchronousExecutionContext.this.done = true;
                            }
                        }
                    }
                }
            }
        }

        public void setTimeout(long time, TimeUnit unit) throws IllegalStateException {
            SynchronousExecutionContext.this.timeout = time;
            SynchronousExecutionContext.this.timeoutUnit = unit;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            Object object = SynchronousExecutionContext.this.responseLock;
            synchronized (object) {
                if (SynchronousExecutionContext.this.done || this.cancelled) {
                    return;
                }
                SynchronousExecutionContext.this.done = true;
                this.cancelled = true;
            }
            this.sendResponse(Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel(int retryAfter) {
            Object object = SynchronousExecutionContext.this.responseLock;
            synchronized (object) {
                if (SynchronousExecutionContext.this.done || this.cancelled) {
                    return;
                }
                SynchronousExecutionContext.this.done = true;
                this.cancelled = true;
            }
            this.sendResponse(Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).header("Retry-After", (Object)retryAfter).build());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel(Date retryAfter) {
            Object object = SynchronousExecutionContext.this.responseLock;
            synchronized (object) {
                if (SynchronousExecutionContext.this.done || this.cancelled) {
                    return;
                }
                SynchronousExecutionContext.this.done = true;
                this.cancelled = true;
            }
            this.sendResponse(Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).header("Retry-After", (Object)retryAfter).build());
        }

        public boolean isSuspended() {
            return !SynchronousExecutionContext.this.done;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public boolean isDone() {
            return SynchronousExecutionContext.this.done;
        }
    }
}

