/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client.publisher;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import org.jboss.resteasy.microprofile.client.publisher.SSEPublisher;
import org.jboss.resteasy.plugins.providers.sse.SseEventInputImpl;
import org.reactivestreams.Publisher;

@Provider
@Consumes(value={"text/event-stream"})
public class MpPublisherMessageBodyReader
implements MessageBodyReader<Publisher<?>> {
    @Context
    protected Providers providers;
    private ExecutorService executor;

    public MpPublisherMessageBodyReader(ExecutorService ex) {
        this.executor = ex;
    }

    public MpPublisherMessageBodyReader() {
        this.executor = Executors.newCachedThreadPool();
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Publisher.class.isAssignableFrom(type) && MediaType.SERVER_SENT_EVENTS_TYPE.isCompatible(mediaType);
    }

    public Publisher<?> readFrom(Class<Publisher<?>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        Map map;
        String elementType;
        MediaType streamType = mediaType;
        if (mediaType.getParameters() != null && (elementType = (String)(map = mediaType.getParameters()).get("element-type")) != null) {
            streamType = MediaType.valueOf((String)elementType);
        }
        SseEventInputImpl sseEventInput = new SseEventInputImpl(annotations, streamType, mediaType, httpHeaders, entityStream);
        return new SSEPublisher(genericType, this.providers, sseEventInput, this.executor);
    }
}

