/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.jta.jms;

import com.arjuna.ats.jta.logging.jtaLogger;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XASession;
import javax.transaction.xa.XAException;
import org.jboss.narayana.jta.jms.XAResourceConsumer;
import org.jboss.narayana.jta.jms.XAResourceFunction;

public class ConnectionManager {
    private final XAConnectionFactory xaConnectionFactory;
    private final String user;
    private final String pass;
    private XAConnection connection;
    private XASession session;

    public ConnectionManager(XAConnectionFactory xaConnectionFactory, String user, String pass) {
        this.xaConnectionFactory = xaConnectionFactory;
        this.user = user;
        this.pass = pass;
    }

    public void connectAndAccept(XAResourceConsumer consumer) throws XAException {
        if (this.isConnected()) {
            consumer.accept(this.session.getXAResource());
            return;
        }
        this.connect();
        try {
            consumer.accept(this.session.getXAResource());
        }
        finally {
            this.disconnect();
        }
    }

    public <T> T connectAndApply(XAResourceFunction<T> function) throws XAException {
        if (this.isConnected()) {
            return function.apply(this.session.getXAResource());
        }
        this.connect();
        try {
            T t = function.apply(this.session.getXAResource());
            return t;
        }
        finally {
            this.disconnect();
        }
    }

    public void connect() throws XAException {
        if (this.isConnected()) {
            return;
        }
        try {
            this.connection = this.createXAConnection();
            this.session = this.connection.createXASession();
        }
        catch (JMSException e) {
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
            jtaLogger.i18NLogger.warn_failed_to_create_jms_connection((Exception)((Object)e));
            throw new XAException(-7);
        }
    }

    public void disconnect() {
        if (!this.isConnected()) {
            return;
        }
        try {
            this.connection.close();
        }
        catch (JMSException e) {
            jtaLogger.i18NLogger.warn_failed_to_close_jms_connection(this.connection.toString(), (Exception)((Object)e));
        }
        finally {
            this.connection = null;
            this.session = null;
        }
    }

    public boolean isConnected() {
        return this.connection != null && this.session != null;
    }

    private XAConnection createXAConnection() throws JMSException {
        if (this.user == null && this.pass == null) {
            return this.xaConnectionFactory.createXAConnection();
        }
        return this.xaConnectionFactory.createXAConnection(this.user, this.pass);
    }
}

