/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.thirdparty;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.codehaus.plexus.util.IOUtil;
import org.jboss.maven.plugins.thirdparty.ComponentInfo;

public class ComponentInfoWriter {
    public static final String DEFAULT_TEMPLATE_FILENAME = "component-info-template.txt";
    public static final String DEFAULT_COMP_INFO_FILENAME = "component-info.xml";
    private static String componentInfoTemplate = "";

    public static String getComponentInfoTemplate() {
        return componentInfoTemplate;
    }

    public static void setComponentInfoTemplate(String theComponentInfoTemplate) {
        componentInfoTemplate = theComponentInfoTemplate;
    }

    public static void loadTemplate() throws IOException {
        InputStream templateInputStream = ComponentInfo.class.getResourceAsStream(DEFAULT_TEMPLATE_FILENAME);
        if (templateInputStream == null) {
            throw new IOException("Unable to load template file");
        }
        componentInfoTemplate = IOUtil.toString((InputStream)templateInputStream);
    }

    public static void writeComponentInfo(ComponentInfo compInfo, File outputFile) throws IOException {
        FileWriter fw = new FileWriter(outputFile);
        fw.write(ComponentInfoWriter.generateComponentInfo(compInfo));
        fw.close();
    }

    public static String generateComponentInfo(ComponentInfo compInfo) {
        StringBuffer compInfoBuffer = new StringBuffer(componentInfoTemplate);
        ComponentInfoWriter.fillPlaceholder(compInfoBuffer, "project.name", compInfo.getProjectName());
        ComponentInfoWriter.fillPlaceholder(compInfoBuffer, "component.id", compInfo.getComponentId());
        ComponentInfoWriter.fillPlaceholder(compInfoBuffer, "project.version", compInfo.getVersion());
        ComponentInfoWriter.fillPlaceholder(compInfoBuffer, "project.license", compInfo.getLicense());
        ComponentInfoWriter.fillPlaceholder(compInfoBuffer, "project.description", compInfo.getDescription());
        ComponentInfoWriter.fillPlaceholder(compInfoBuffer, "project.scm", compInfo.getScm());
        StringBuffer artifactLines = new StringBuffer();
        Iterator artifactIter = compInfo.getArtifactIds().iterator();
        while (artifactIter.hasNext()) {
            artifactLines.append("    <artifact id=\"" + artifactIter.next() + "\"/>\n");
        }
        ComponentInfoWriter.fillPlaceholder(compInfoBuffer, "artifacts", artifactLines.toString());
        StringBuffer exportsString = new StringBuffer();
        Iterator exportIter = compInfo.getExports().iterator();
        while (exportIter.hasNext()) {
            exportsString.append("      <include input=\"" + exportIter.next() + "\"/>\n");
        }
        ComponentInfoWriter.fillPlaceholder(compInfoBuffer, "includes", exportsString.toString());
        ComponentInfoWriter.fillPlaceholder(compInfoBuffer, "imports", ComponentInfoWriter.generateImportsString(compInfo));
        return compInfoBuffer.toString();
    }

    private static String generateImportsString(ComponentInfo compInfo) {
        StringBuffer importsString = new StringBuffer();
        if (compInfo.getImports() != null) {
            Set componentNames = compInfo.getImports().keySet();
            for (ComponentInfo component : componentNames) {
                importsString.append("    <import componentref=\"" + component.toString().replace('.', '/') + "\">\n");
                String componentVersions = compInfo.getImports().get(component).toString();
                String[] versions = componentVersions.split(",");
                for (int i = 0; i < versions.length; ++i) {
                    importsString.append("      <compatible version=\"" + versions[i].trim() + "\"/>\n");
                }
                importsString.append("    </import>\n");
            }
        }
        return importsString.toString();
    }

    public static String getLibrariesEntEntry(ComponentInfo compInfo) {
        StringBuffer libEnt = new StringBuffer();
        String libEntCompId = compInfo.getLibrariesEntCompId();
        libEnt.append("<!-- " + compInfo.getComponentId() + " -->\n");
        libEnt.append("<property name=\"" + libEntCompId + ".root\" value=\"${project.thirdparty}/" + compInfo.getComponentId().replace('.', '/') + "\"/>\n");
        libEnt.append("<property name=\"" + libEntCompId + ".lib\" value=\"${" + libEntCompId + ".root}/lib/\"/>\n");
        libEnt.append("<property name=\"" + libEntCompId + ".resources\" value=\"${" + libEntCompId + ".root}/resources/\"/>\n");
        libEnt.append("<path id=\"" + libEntCompId + ".classpath\">\n");
        ArrayList sortedArtifacts = new ArrayList(compInfo.getArtifactIds());
        Collections.sort(sortedArtifacts);
        for (int i = 0; i < sortedArtifacts.size(); ++i) {
            String currArtifact = (String)sortedArtifacts.get(i);
            libEnt.append("   <pathelement path=\"${" + libEntCompId + ".lib}/" + currArtifact + "\"/>\n");
        }
        libEnt.append("</path>\n\n");
        return libEnt.toString();
    }

    public static void fillPlaceholder(StringBuffer buffer, String placeholder, String value) {
        int start = 0;
        while ((start = buffer.indexOf("${" + placeholder + "}")) != -1) {
            int end = start + ("${" + placeholder + "}").length();
            buffer.replace(start, end, value);
        }
    }
}

