/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import java.io.Console;
import java.nio.charset.Charset;
import java.security.AccessController;

final class JDKSpecific {
    private static final Charset CONSOLE_CHARSET;

    private JDKSpecific() {
    }

    static Charset consoleCharset() {
        return CONSOLE_CHARSET;
    }

    static {
        Charset charset;
        Console console = System.console();
        if (console != null) {
            charset = console.charset();
        } else {
            String encodingName = AccessController.doPrivileged(() -> System.getProperty("stdout.encoding"));
            if (encodingName == null) {
                encodingName = AccessController.doPrivileged(() -> System.getProperty("native.encoding"));
            }
            charset = encodingName == null ? Charset.defaultCharset() : Charset.forName(encodingName);
        }
        CONSOLE_CHARSET = charset;
    }
}

