/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.model;

import com.sun.codemodel.internal.CodeWriter;
import com.sun.codemodel.internal.JAnnotationUse;
import com.sun.codemodel.internal.JBlock;
import com.sun.codemodel.internal.JClass;
import com.sun.codemodel.internal.JClassAlreadyExistsException;
import com.sun.codemodel.internal.JCodeModel;
import com.sun.codemodel.internal.JDefinedClass;
import com.sun.codemodel.internal.JDocComment;
import com.sun.codemodel.internal.JExpr;
import com.sun.codemodel.internal.JExpression;
import com.sun.codemodel.internal.JFieldVar;
import com.sun.codemodel.internal.JMethod;
import com.sun.codemodel.internal.JType;
import com.sun.codemodel.internal.JTypeVar;
import java.io.IOException;
import javax.annotation.Generated;
import javax.tools.JavaFileObject;
import org.jboss.logging.model.ClassModelUtil;
import org.jboss.logging.model.JavaFileObjectCodeWriter;

public abstract class ClassModel {
    private static final String MESSAGE_METHOD_SUFFIX = "$str";
    private static final JType[] EMPTY_TYPE_ARRAY = new JTypeVar[0];
    private String[] interfaceNames;
    private String superClassName;
    private String className;
    private JCodeModel codeModel;
    private JDefinedClass definedClass;
    private String projectCode;

    public ClassModel(String className, String superClassName) {
        this(className, null, superClassName, new String[0]);
    }

    protected ClassModel(String className, String projectCode, String superClassName, String ... interfaceNames) {
        this.interfaceNames = interfaceNames;
        this.superClassName = superClassName;
        this.className = className;
        this.projectCode = projectCode;
        this.initModel();
    }

    public final void create(JavaFileObject fileObject) throws IOException, IllegalStateException {
        JCodeModel model = this.generateModel();
        model.build((CodeWriter)new JavaFileObjectCodeWriter(fileObject));
    }

    protected JCodeModel generateModel() throws IllegalStateException {
        return this.codeModel;
    }

    protected JMethod addMessageMethod(String methodName, String returnValue) {
        if (this.codeModel == null || this.definedClass == null) {
            throw new IllegalStateException("The code model or the corresponding defined class is null");
        }
        if (returnValue == null) {
            return null;
        }
        String internalMethodName = methodName + MESSAGE_METHOD_SUFFIX;
        JMethod method = this.definedClass.getMethod(internalMethodName, EMPTY_TYPE_ARRAY);
        if (method == null) {
            JFieldVar methodField = (JFieldVar)this.definedClass.fields().get(methodName);
            if (methodField == null) {
                methodField = this.definedClass.field(28, String.class, methodName);
                methodField.init(JExpr.lit((String)returnValue));
            }
            JClass returnType = this.codeModel.ref(String.class);
            method = this.definedClass.method(2, (JType)returnType, internalMethodName);
            JBlock body = method.body();
            body._return((JExpression)methodField);
        }
        return method;
    }

    public JCodeModel getCodeModel() {
        return this.codeModel;
    }

    public final JDefinedClass getDefinedClass() {
        return this.definedClass;
    }

    public final String getClassName() {
        return this.className;
    }

    public String getProjectCode() {
        return this.projectCode;
    }

    private void initModel() {
        this.codeModel = new JCodeModel();
        try {
            this.definedClass = this.codeModel._class(this.className);
        }
        catch (JClassAlreadyExistsException e) {
            throw new IllegalStateException("Class " + this.className + " has already been defined. Cannot generate the class.", e);
        }
        JAnnotationUse generatedAnnotation = this.definedClass.annotate(Generated.class);
        generatedAnnotation.param("value", this.getClass().getName());
        generatedAnnotation.param("date", ClassModelUtil.generatedDateValue());
        JDocComment docComment = this.definedClass.javadoc();
        docComment.add((Object)"Warning this class consists of generated code.");
        if (this.superClassName != null) {
            this.definedClass._extends(this.codeModel.ref(this.superClassName));
        }
        if (this.interfaceNames != null) {
            for (String intf : this.interfaceNames) {
                this.definedClass._implements(this.codeModel.ref(intf.replace("$", ".")));
            }
        }
    }
}

