/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.generator;

import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import org.jboss.logging.util.ElementHelper;

public class ReturnType {
    private final TypeMirror returnType;
    private boolean defaultConstructor = false;
    private boolean stringConstructor = false;
    private boolean throwableConstructor = false;
    private boolean stringAndThrowableConstructor = false;
    private boolean throwableAndStringConstructor = false;

    private ReturnType(TypeMirror returnType) {
        this.returnType = returnType;
    }

    public static ReturnType of(TypeMirror returnType, Types typeUtil) {
        ReturnType result = new ReturnType(returnType);
        result.init(typeUtil);
        return result;
    }

    private void init(Types typeUtil) {
        if (!this.returnType.getKind().isPrimitive() && this.returnType.getKind() != TypeKind.VOID) {
            Element element = typeUtil.asElement(this.returnType);
            List<ExecutableElement> constructors = ElementFilter.constructorsIn(element.getEnclosedElements());
            for (ExecutableElement constructor : constructors) {
                if (!constructor.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                List<? extends VariableElement> params = constructor.getParameters();
                switch (params.size()) {
                    case 0: {
                        this.defaultConstructor = true;
                        break;
                    }
                    case 1: {
                        if (ElementHelper.isAssignableFrom(params.get(0).asType(), String.class)) {
                            this.stringConstructor = true;
                            break;
                        }
                        if (!ElementHelper.isAssignableFrom(Throwable.class, params.get(0).asType())) break;
                        this.throwableConstructor = true;
                        break;
                    }
                    case 2: {
                        if (ElementHelper.isAssignableFrom(params.get(0).asType(), String.class) && ElementHelper.isAssignableFrom(Throwable.class, params.get(1).asType())) {
                            this.stringAndThrowableConstructor = true;
                            break;
                        }
                        if (!ElementHelper.isAssignableFrom(Throwable.class, params.get(0).asType()) || !ElementHelper.isAssignableFrom(params.get(1).asType(), String.class)) break;
                        this.throwableAndStringConstructor = true;
                    }
                }
            }
        }
    }

    public boolean isPrimitive() {
        return this.returnType.getKind().isPrimitive();
    }

    public String getReturnTypeAsString() {
        return ((Object)this.returnType).toString();
    }

    public boolean hasDefaultConstructor() {
        return this.defaultConstructor;
    }

    public boolean hasStringAndThrowableConstructor() {
        return this.stringAndThrowableConstructor;
    }

    public boolean hasStringConstructor() {
        return this.stringConstructor;
    }

    public boolean hasThrowableAndStringConstructor() {
        return this.throwableAndStringConstructor;
    }

    public boolean hasThrowableConstructor() {
        return this.throwableConstructor;
    }

    public boolean isException() {
        return ElementHelper.isAssignableFrom(Throwable.class, this.returnType);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.returnType == null ? 0 : ((Object)this.returnType).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ReturnType)) {
            return false;
        }
        ReturnType other = (ReturnType)obj;
        return !(this.returnType == null ? other.returnType != null : ((Object)this.returnType).equals(other.returnType));
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getName()).append("(returnType=").append(this.returnType).append(", stringConstructor=").append(this.stringConstructor).append(", throwableConstructor=").append(this.throwableConstructor).append(", stringAndThrowableConstructor=").append(this.stringAndThrowableConstructor).append(", throwableAndStringConstructor=").append(this.throwableAndStringConstructor).append(")");
        return result.toString();
    }
}

