/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.jboss.logging.Annotations;
import org.jboss.logging.generator.Message;
import org.jboss.logging.generator.MethodParameter;
import org.jboss.logging.generator.ReturnType;
import org.jboss.logging.util.ElementHelper;

public class MethodDescriptor
implements Iterable<MethodDescriptor>,
Comparable<MethodDescriptor> {
    private static List<MethodDescriptor> descriptors;
    private MethodParameter cause;
    private ReturnType returnType;
    private final Annotations annotations;
    private Message message;
    private ExecutableElement method;
    private final List<MethodParameter> parameters = new ArrayList<MethodParameter>();

    private MethodDescriptor(Annotations annotations) {
        this.annotations = annotations;
    }

    protected static MethodDescriptor create(Elements elementUtil, Types typeUtil, Collection<ExecutableElement> methods, Annotations annotations) {
        MethodDescriptor result = new MethodDescriptor(annotations);
        descriptors = new ArrayList<MethodDescriptor>();
        boolean first = true;
        for (ExecutableElement method : methods) {
            MethodDescriptor current;
            if (first) {
                current = result;
                first = false;
            } else {
                current = new MethodDescriptor(annotations);
            }
            current.init(elementUtil, typeUtil, method);
            descriptors.add(current);
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MethodDescriptor)) {
            return false;
        }
        MethodDescriptor other = (MethodDescriptor)obj;
        return !(this.method == null ? other.method != null : !this.method.equals(other.method));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append("(name=");
        stringBuilder.append(this.name());
        stringBuilder.append(",message=");
        stringBuilder.append(this.message);
        stringBuilder.append(",loggerMethod=");
        stringBuilder.append(this.loggerMethod());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public int compareTo(MethodDescriptor o) {
        int c = this.method.getSimpleName().toString().compareTo(o.method.getSimpleName().toString());
        c = c != 0 ? c : this.method.getKind().compareTo(o.method.getKind());
        int n = c = c != 0 ? c : this.method.getParameters().size() - o.method.getParameters().size();
        if (c == 0) {
            List<? extends VariableElement> parms = this.method.getParameters();
            for (int i = 0; i < parms.size(); ++i) {
                VariableElement var1 = parms.get(i);
                VariableElement var2 = o.method.getParameters().get(i);
                c = var1.getKind().compareTo(var2.getKind());
            }
        }
        return c;
    }

    @Override
    public Iterator<MethodDescriptor> iterator() {
        Collection<Object> result = descriptors == null ? Collections.emptyList() : Collections.unmodifiableCollection(descriptors);
        return result.iterator();
    }

    public boolean hasMessageId() {
        return this.message.hasId();
    }

    public Annotations.FormatType messageFormat() {
        return this.message.format();
    }

    public String messageValue() {
        return this.message.value();
    }

    public int messageId() {
        return this.message.id();
    }

    public String name() {
        return this.method.getSimpleName().toString();
    }

    public boolean hasCause() {
        return this.cause != null;
    }

    public MethodParameter cause() {
        return this.cause;
    }

    public ReturnType returnType() {
        return this.returnType;
    }

    public String loggerMethod() {
        return this.annotations.loggerMethod(this.method, this.message.format());
    }

    public String logLevelParameter() {
        return this.annotations.logLevel(this.method);
    }

    public Collection<MethodParameter> parameters() {
        return Collections.unmodifiableCollection(this.parameters);
    }

    public boolean isLoggerMethod() {
        return ElementHelper.isAnnotatedWith(this.method, this.annotations.logMessage());
    }

    public Collection<MethodDescriptor> find(String methodName) {
        LinkedHashSet<MethodDescriptor> result = new LinkedHashSet<MethodDescriptor>();
        for (MethodDescriptor methodDesc : descriptors) {
            if (!methodName.equals(methodDesc.name())) continue;
            result.add(methodDesc);
        }
        return result;
    }

    private void init(Elements elementUtil, Types typeUtil, ExecutableElement method) {
        this.method = method;
        Message message = Message.of(this.annotations.messageId(method), this.annotations.hasMessageId(method), this.annotations.messageValue(method), this.annotations.messageFormat(method));
        this.returnType = ReturnType.of(method.getReturnType(), typeUtil);
        Collection<MethodDescriptor> methodDescriptors = this.find(this.name());
        for (MethodDescriptor methodDescriptor : methodDescriptors) {
            if (message != null && methodDescriptor.message.value() != null && message.value() == null) {
                message = methodDescriptor.message;
            }
            if (message == null) continue;
            break;
        }
        for (MethodDescriptor methodDescriptor : methodDescriptors) {
            if (methodDescriptor.message.value() != null) continue;
            methodDescriptor.message = message;
            descriptors.remove(methodDescriptor);
            descriptors.add(methodDescriptor);
        }
        for (VariableElement variableElement : method.getParameters()) {
            if (variableElement.getAnnotation(this.annotations.cause()) != null) {
                this.cause = new MethodParameter(this.annotations, typeUtil.asElement(variableElement.asType()).toString(), variableElement);
            }
            String formatClass = null;
            for (AnnotationMirror annotationMirror : variableElement.getAnnotationMirrors()) {
                DeclaredType annotationType = annotationMirror.getAnnotationType();
                if (!annotationType.equals(typeUtil.getDeclaredType(elementUtil.getTypeElement(this.annotations.formatWith().getName()), new TypeMirror[0]))) continue;
                AnnotationValue value = annotationMirror.getElementValues().values().iterator().next();
                formatClass = ((TypeElement)((DeclaredType)value.getValue()).asElement()).getQualifiedName().toString();
            }
            if (variableElement.asType().getKind().isPrimitive()) {
                this.parameters.add(new MethodParameter(this.annotations, ((Object)variableElement.asType()).toString(), variableElement, formatClass));
                continue;
            }
            this.parameters.add(new MethodParameter(this.annotations, typeUtil.asElement(variableElement.asType()).toString(), variableElement, formatClass));
        }
        this.message = message;
    }
}

