/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;
import org.jboss.profileservice.spi.NoSuchDeploymentException;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.system.server.profileservice.repository.AbstractProfileDeployment;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractVFSProfileSource {
    protected final Collection<URI> uris;
    private Map<String, ProfileDeployment> applicationCtxs = new ConcurrentHashMap<String, ProfileDeployment>();
    private VirtualFileFilter deploymentFilter;
    private final Map<String, VirtualFile> applicationVFCache = new ConcurrentHashMap<String, VirtualFile>();
    private boolean recursiveScan = true;
    private volatile long lastModified;
    protected final Logger log = Logger.getLogger(this.getClass());

    public AbstractVFSProfileSource(URI[] uris) {
        if (uris == null) {
            throw new IllegalArgumentException("Null uris");
        }
        this.uris = new ArrayList<URI>();
        for (URI uri : uris) {
            this.uris.add(uri);
        }
    }

    public VirtualFileFilter getDeploymentFilter() {
        return this.deploymentFilter;
    }

    public void setDeploymentFilter(VirtualFileFilter deploymentFilter) {
        this.deploymentFilter = deploymentFilter;
    }

    public boolean isRecursiveScan() {
        return this.recursiveScan;
    }

    public void setRecursiveScan(boolean recursiveScan) {
        this.recursiveScan = recursiveScan;
    }

    public URI[] getRepositoryURIs() {
        return this.uris.toArray(new URI[this.uris.size()]);
    }

    public Set<String> getDeploymentNames() {
        return this.applicationCtxs.keySet();
    }

    public Collection<ProfileDeployment> getDeployments() {
        return this.applicationCtxs.values();
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void destroy() {
        this.applicationCtxs.clear();
        this.applicationVFCache.clear();
        this.updateLastModfied();
    }

    public void addDeployment(String vfsPath, ProfileDeployment d) throws Exception {
        if (d == null) {
            throw new IllegalArgumentException("Null deployment");
        }
        this.applicationCtxs.put(d.getName(), d);
        if (d.getRoot() != null) {
            this.applicationVFCache.put(d.getName(), d.getRoot());
        }
        this.updateLastModfied();
    }

    public ProfileDeployment getDeployment(String vfsPath) throws NoSuchDeploymentException {
        if (vfsPath == null) {
            throw new IllegalArgumentException("Null vfsPath");
        }
        return this.applicationCtxs.get(vfsPath);
    }

    public ProfileDeployment removeDeployment(String vfsPath) throws Exception {
        if (vfsPath == null) {
            throw new IllegalArgumentException("Null vfsPath");
        }
        ProfileDeployment deployment = this.getDeployment(vfsPath);
        this.applicationCtxs.remove(deployment.getName());
        this.applicationVFCache.remove(deployment.getName());
        this.updateLastModfied();
        return deployment;
    }

    protected void loadApplications(VirtualFile applicationDir) throws Exception {
        ArrayList<VirtualFile> added = new ArrayList<VirtualFile>();
        this.addedDeployment(added, applicationDir);
        for (VirtualFile vf : added) {
            ProfileDeployment vfCtx = AbstractVFSProfileSource.createDeployment(vf);
            this.addDeployment(vfCtx.getName(), vfCtx);
        }
    }

    protected void addedDeployments(List<VirtualFile> list, VirtualFile root) throws IOException, URISyntaxException {
        if (root.isLeaf() || root.isArchive()) {
            this.addedDeployment(list, root);
        } else {
            List components = root.getChildren();
            for (VirtualFile component : components) {
                this.addedDeployment(list, component);
            }
        }
    }

    protected void addedDeployment(List<VirtualFile> list, VirtualFile component) throws IOException, URISyntaxException {
        if (this.deploymentFilter != null && !this.deploymentFilter.accepts(component)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("ignoring " + component));
            }
            return;
        }
        String key = component.toURI().toString();
        if (!this.acceptsDeployment(key)) {
            return;
        }
        if (!component.isLeaf() && !component.isArchive()) {
            if (this.isRecursiveScan() && component.getName().indexOf(46) == -1) {
                this.addedDeployments(list, component);
            } else {
                list.add(component);
            }
        } else {
            list.add(component);
        }
    }

    protected boolean acceptsDeployment(String name) {
        return !this.applicationCtxs.containsKey(name);
    }

    protected List<String> findDeploymentContent(String name) {
        if (this.applicationVFCache.containsKey(name)) {
            return Collections.singletonList(name);
        }
        ArrayList<String> contents = new ArrayList<String>();
        Iterator<String> i$ = this.applicationVFCache.keySet().iterator();
        while (i$.hasNext()) {
            String cacheName;
            String fixedName = cacheName = i$.next();
            if (cacheName.endsWith("/")) {
                fixedName = cacheName.substring(0, cacheName.length() - 1);
            }
            if (!fixedName.endsWith(name)) continue;
            contents.add(cacheName);
        }
        return contents;
    }

    protected String addVirtualFileCache(VirtualFile vf) throws MalformedURLException, URISyntaxException {
        String uri = vf.toURI().toString();
        this.applicationVFCache.put(uri, vf);
        return uri;
    }

    protected VirtualFile getCachedVirtualFile(String name) {
        return this.applicationVFCache.get(name);
    }

    protected VirtualFile getCachedVirtualFile(URI uri) throws IOException {
        VirtualFile vf = this.getCachedVirtualFile(uri.toString());
        if (vf == null) {
            vf = VFS.getRoot((URI)uri);
            this.applicationVFCache.put(uri.toString(), vf);
        }
        return vf;
    }

    protected static ProfileDeployment createDeployment(VirtualFile vf) throws Exception {
        return new AbstractProfileDeployment(vf);
    }

    protected void updateLastModfied() {
        this.lastModified = System.currentTimeMillis();
    }
}

