/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.spi.deployer;

import java.io.InputStream;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.jboss.deployers.vfs.spi.deployer.JAXPDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.util.xml.DOMWriter;
import org.jboss.util.xml.JBossErrorHandler;
import org.jboss.virtual.VirtualFile;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XSLDeployer<T>
extends JAXPDeployer<T> {
    protected String xslPath;
    private Templates templates;

    public XSLDeployer(Class<T> deploymentType) {
        super(deploymentType);
    }

    public String getXSLPath() {
        return this.xslPath;
    }

    public void setXSLPath(String xslPath) {
        this.xslPath = xslPath;
    }

    public Templates getTemplates() {
        if (this.templates == null) {
            throw new IllegalStateException("Templates have not been constructed");
        }
        return this.templates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create() throws Exception {
        super.create();
        TransformerFactory tf = TransformerFactory.newInstance();
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.xslPath);
        try {
            StreamSource ss = new StreamSource(is);
            ss.setSystemId(this.xslPath);
            this.templates = tf.newTemplates(ss);
            this.log.debug((Object)("Created templates: " + this.templates));
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.templates = null;
    }

    @Override
    protected T parse(VFSDeploymentUnit unit, VirtualFile file, T root) throws Exception {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        Document document = this.doParse(unit, file);
        Transformer trans = this.getTemplates().newTransformer();
        trans.setErrorListener((ErrorListener)new JBossErrorHandler(file.getPathName(), null));
        DOMSource s = new DOMSource(document);
        s.setSystemId(file.toURI().toString());
        DOMResult r = new DOMResult();
        this.setParameters(trans);
        trans.transform(s, r);
        document = (Document)r.getNode();
        String docStr = DOMWriter.printNode((Node)document, (boolean)true);
        this.log.debug((Object)("Transformed " + file.getPathName() + " into " + docStr));
        return (T)this.parse(unit, file, (T)document);
    }

    protected void setParameters(Transformer trans) throws Exception {
    }
}

