/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.classloading;

import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classloader.spi.Loader;
import org.jboss.classloader.spi.ParentPolicy;
import org.jboss.classloader.spi.ShutdownPolicy;
import org.jboss.classloading.spi.metadata.ClassLoadingDomainMetaData;
import org.jboss.classloading.spi.metadata.LoaderMetaData;
import org.jboss.classloading.spi.metadata.ParentPolicyMetaData;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractClassLoadingDomainDeployer
extends AbstractSimpleRealDeployer<ClassLoadingDomainMetaData> {
    private ClassLoaderSystem system;

    public AbstractClassLoadingDomainDeployer() {
        super(ClassLoadingDomainMetaData.class);
        this.setStage(DeploymentStages.DESCRIBE);
    }

    public void create() {
        if (this.system == null) {
            throw new IllegalStateException("The system has not been set");
        }
    }

    public void deploy(DeploymentUnit unit, ClassLoadingDomainMetaData deployment) throws DeploymentException {
        ParentPolicyMetaData ppmd;
        String name = deployment.getName();
        if (name == null || "<unknown>".equals(name)) {
            name = unit.getName();
        }
        ParentPolicy pp = (ppmd = deployment.getParentPolicy()) != null ? ppmd.createParentPolicy() : ParentPolicy.BEFORE;
        Loader parent = null;
        String parentDomain = deployment.getParentDomain();
        LoaderMetaData lmd = deployment.getParent();
        if (parentDomain != null && lmd != null) {
            throw new DeploymentException("Cannot define both: parent-domain and parent loader: " + deployment);
        }
        if (lmd != null) {
            parent = lmd.getValue();
        } else if (parentDomain != null) {
            parent = this.system.getDomain(parentDomain);
        }
        ShutdownPolicy shutdownPolicy = deployment.getShutdownPolicy();
        Boolean useLoadClassForParent = deployment.getUseLoadClassForParent();
        this.system.createAndRegisterDomain(name, pp, parent, shutdownPolicy, useLoadClassForParent);
    }

    public void undeploy(DeploymentUnit unit, ClassLoadingDomainMetaData deployment) {
        ClassLoaderDomain domain;
        String name = deployment.getName();
        if (name == null || "<unknown>".equals(name)) {
            name = unit.getName();
        }
        if ((domain = this.system.getDomain(name)) != null) {
            this.system.unregisterDomain(domain);
        }
    }

    public ClassLoaderSystem getSystem() {
        return this.system;
    }

    public void setSystem(ClassLoaderSystem system) {
        this.system = system;
    }
}

