/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.jboss.deployers.plugins.annotations.DefaultElement;
import org.jboss.metadata.spi.signature.ConstructorParametersSignature;
import org.jboss.metadata.spi.signature.MethodParametersSignature;
import org.jboss.metadata.spi.signature.Signature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParametersElement<A extends Annotation, M extends AnnotatedElement>
extends DefaultElement<A, M> {
    public ParametersElement(ClassLoader classLoader, String className, Signature signature, Class<A> annClass, A annotation, Class<M> aoClass) {
        super(classLoader, className, signature, annClass, annotation, aoClass);
    }

    @Override
    protected A readAnnotation() {
        Annotation[] annotations = null;
        Class<?> clazz = this.getOwner();
        if (this.signature instanceof ConstructorParametersSignature) {
            ConstructorParametersSignature cps = (ConstructorParametersSignature)this.signature;
            try {
                Constructor<?> constructor = clazz.getConstructor(this.signature.getParametersTypes(clazz));
                annotations = constructor.getParameterAnnotations()[cps.getParam()];
            }
            catch (NoSuchMethodException ignored) {}
        } else if (this.signature instanceof MethodParametersSignature) {
            MethodParametersSignature mps = (MethodParametersSignature)this.signature;
            try {
                Method method = clazz.getMethod(this.signature.getName(), this.signature.getParametersTypes(clazz));
                annotations = method.getParameterAnnotations()[mps.getParam()];
            }
            catch (NoSuchMethodException ignored) {
                // empty catch block
            }
        }
        if (annotations == null || annotations.length == 0) {
            throw new IllegalArgumentException("Expected annotations " + this.className + "." + this.signature);
        }
        for (Annotation annotation : annotations) {
            if (!this.annClass.equals(annotation.annotationType())) continue;
            return (A)((Annotation)this.annClass.cast(annotation));
        }
        throw new IllegalArgumentException("No matching annotation: " + Arrays.asList(annotations));
    }
}

