/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import org.jboss.deployers.plugins.annotations.AbstractElement;
import org.jboss.metadata.spi.signature.ConstructorParametersSignature;
import org.jboss.metadata.spi.signature.ConstructorSignature;
import org.jboss.metadata.spi.signature.FieldSignature;
import org.jboss.metadata.spi.signature.MethodParametersSignature;
import org.jboss.metadata.spi.signature.MethodSignature;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.reflect.plugins.introspection.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultElement<A extends Annotation, M extends AnnotatedElement>
extends AbstractElement<A, M> {
    protected Signature signature;
    protected Class<M> aoClass;

    public DefaultElement(ClassLoader classLoader, String className, Signature signature, Class<A> annClass, A annotation, Class<M> aoClass) {
        super(classLoader, className, annClass, annotation);
        if (signature == null) {
            throw new IllegalArgumentException("Null signature");
        }
        if (aoClass == null) {
            throw new IllegalArgumentException("Null ao class");
        }
        this.signature = signature;
        this.aoClass = aoClass;
    }

    public M getAnnotatedElement() {
        AccessibleObject result = null;
        Class<?> clazz = this.getOwner();
        if (this.signature instanceof ConstructorSignature || this.signature instanceof ConstructorParametersSignature) {
            try {
                result = clazz.getConstructor(this.signature.getParametersTypes(clazz));
            }
            catch (NoSuchMethodException ignored) {}
        } else if (this.signature instanceof MethodSignature || this.signature instanceof MethodParametersSignature) {
            try {
                result = clazz.getMethod(this.signature.getName(), this.signature.getParametersTypes(clazz));
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        } else if (this.signature instanceof FieldSignature) {
            result = ReflectionUtils.findField(clazz, (String)this.signature.getName());
        }
        if (result == null) {
            throw new IllegalArgumentException("Expected accessible object " + this.className + "." + this.signature);
        }
        if (!this.aoClass.isInstance(result)) {
            throw new IllegalArgumentException("Expected accessible object " + this.className + "." + this.signature + " of type " + this.aoClass);
        }
        return (M)((AnnotatedElement)this.aoClass.cast(result));
    }

    @Override
    public int getHashCode() {
        int hash = super.getHashCode();
        hash += 19 * this.signature.hashCode();
        return hash += 37 * this.aoClass.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        DefaultElement de = (DefaultElement)((Object)DefaultElement.class.cast(obj));
        if (!this.aoClass.equals(de.aoClass)) {
            return false;
        }
        return this.signature.equals((Object)de.signature);
    }
}

