/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.plugin.common;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.client.helpers.ClientConstants;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class Operations
extends ClientConstants {
    public static final String CHILD_TYPE = "child-type";
    public static final String ENABLE = "enable";
    public static final String LAUNCH_TYPE = "launch-type";
    public static final String PROFILE = "profile";
    public static final String READ_ATTRIBUTE_OPERATION = "read-attribute";
    public static final String READ_CHILDREN_NAMES = "read-children-names";
    public static final String READ_RESOURCE = "read-resource";
    public static final String READ_RESOURCE_OPERATION = "read-resource";
    public static final String RECURSIVE = "recursive";
    public static final String RELOAD = "reload";
    public static final String REMOVE_OPERATION = "remove";
    public static final String SERVER_STATE = "server-state";
    public static final String SHUTDOWN = "shutdown";
    public static final String UNDEFINE_ATTRIBUTE_OPERATION = "undefine-attribute";
    public static final String VALUE = "value";
    public static final String WRITE_ATTRIBUTE_OPERATION = "write-attribute";

    public static boolean isSuccessfulOutcome(ModelNode outcome) {
        return outcome.get("outcome").asString().equals("success");
    }

    public static boolean successful(ModelNode result) {
        return Operations.isSuccessfulOutcome(result);
    }

    public static String getFailureDescription(ModelNode result) {
        if (Operations.isSuccessfulOutcome(result)) {
            return "";
        }
        String msg = result.hasDefined("failure-description") ? (result.hasDefined("operation") ? String.format("Operation '%s' at address '%s' failed: %s", result.get("operation"), result.get("address"), result.get("failure-description")) : String.format("Operation failed: %s", result.get("failure-description"))) : String.format("An unexpected response was found checking the deployment. Result: %s", result);
        return msg;
    }

    public static ModelNode getOperationAddress(ModelNode op) {
        return op.hasDefined("address") ? op.get("address") : new ModelNode();
    }

    public static ModelNode createAddOperation(ModelNode address) {
        return Operations.createOperation("add", address);
    }

    public static ModelNode createRemoveOperation(ModelNode address) {
        return Operations.createOperation(REMOVE_OPERATION, address);
    }

    public static ModelNode createRemoveOperation(ModelNode address, boolean recursive) {
        return Operations.createOperation(REMOVE_OPERATION, address, recursive);
    }

    public static ModelNode createListDeploymentsOperation() {
        ModelNode op = Operations.createOperation(READ_CHILDREN_NAMES);
        op.get(CHILD_TYPE).set("deployment");
        return op;
    }

    public static ModelNode createCompositeOperation() {
        ModelNode op = Operations.createOperation("composite");
        op.get("rollback-on-runtime-failure").set(true);
        op.get("steps").setEmptyList();
        return op;
    }

    public static ModelNode createReadAttributeOperation(String attributeName) {
        ModelNode op = new ModelNode();
        op.get("address").setEmptyList();
        op.get("operation").set(READ_ATTRIBUTE_OPERATION);
        op.get("name").set(attributeName);
        return op;
    }

    public static ModelNode createReadAttributeOperation(ModelNode address, String attributeName) {
        ModelNode op = Operations.createOperation(READ_ATTRIBUTE_OPERATION, address);
        op.get("name").set(attributeName);
        return op;
    }

    public static ModelNode createReadResourceOperation(ModelNode address) {
        return Operations.createReadResourceOperation(address, false);
    }

    public static ModelNode createReadResourceOperation(ModelNode address, boolean recursive) {
        ModelNode op = Operations.createOperation("read-resource", address);
        op.get(RECURSIVE).set(recursive);
        return op;
    }

    public static ModelNode createUndefineAttributeOperation(ModelNode address, String attributeName) {
        ModelNode op = Operations.createOperation(UNDEFINE_ATTRIBUTE_OPERATION, address);
        op.get("name").set(attributeName);
        return op;
    }

    public static ModelNode createWriteAttributeOperation(ModelNode address, String attributeName, boolean value) {
        ModelNode op = Operations.createNoValueWriteOperation(address, attributeName);
        op.get(VALUE).set(value);
        return op;
    }

    public static ModelNode createWriteAttributeOperation(ModelNode address, String attributeName, int value) {
        ModelNode op = Operations.createNoValueWriteOperation(address, attributeName);
        op.get(VALUE).set(value);
        return op;
    }

    public static ModelNode createWriteAttributeOperation(ModelNode address, String attributeName, long value) {
        ModelNode op = Operations.createNoValueWriteOperation(address, attributeName);
        op.get(VALUE).set(value);
        return op;
    }

    public static ModelNode createWriteAttributeOperation(ModelNode address, String attributeName, String value) {
        ModelNode op = Operations.createNoValueWriteOperation(address, attributeName);
        op.get(VALUE).set(value);
        return op;
    }

    public static ModelNode createWriteAttributeOperation(ModelNode address, String attributeName, ModelNode value) {
        ModelNode op = Operations.createNoValueWriteOperation(address, attributeName);
        op.get(VALUE).set(value);
        return op;
    }

    public static ModelNode createAddress(String key, String name) {
        ModelNode address = new ModelNode().setEmptyList();
        address.add(key, name);
        return address;
    }

    public static ModelNode createOperation(String operation) {
        ModelNode op = new ModelNode();
        op.get("operation").set(operation);
        op.get("address").setEmptyList();
        return op;
    }

    public static ModelNode createOperation(String operation, ModelNode address) {
        if (address.getType() != ModelType.LIST) {
            throw new IllegalArgumentException("The address type must be a list.");
        }
        ModelNode op = Operations.createOperation(operation);
        op.get("address").set(address);
        return op;
    }

    public static ModelNode createOperation(String operation, ModelNode address, boolean recursive) {
        ModelNode op = Operations.createOperation(operation, address);
        op.get(RECURSIVE).set(recursive);
        return op;
    }

    public static Property getChildAddress(ModelNode address) {
        if (address.getType() != ModelType.LIST) {
            throw new IllegalArgumentException("The address type must be a list.");
        }
        List addressParts = address.asPropertyList();
        if (addressParts.isEmpty()) {
            throw new IllegalArgumentException("The address is empty.");
        }
        return (Property)addressParts.get(addressParts.size() - 1);
    }

    public static ModelNode getParentAddress(ModelNode address) {
        if (address.getType() != ModelType.LIST) {
            throw new IllegalArgumentException("The address type must be a list.");
        }
        ModelNode result = new ModelNode();
        List addressParts = address.asPropertyList();
        if (addressParts.isEmpty()) {
            throw new IllegalArgumentException("The address is empty.");
        }
        for (int i = 0; i < addressParts.size() - 1; ++i) {
            Property property = (Property)addressParts.get(i);
            result.add(property.getName(), property.getValue());
        }
        return result;
    }

    public static String readResultAsString(ModelNode result) {
        return result.hasDefined("result") ? result.get("result").asString() : "";
    }

    public static ModelNode readResult(ModelNode result) {
        return result.hasDefined("result") ? result.get("result") : new ModelNode();
    }

    private static ModelNode createNoValueWriteOperation(ModelNode address, String attributeName) {
        ModelNode op = Operations.createOperation(WRITE_ATTRIBUTE_OPERATION, address);
        op.get("name").set(attributeName);
        return op;
    }

    public static class CompositeOperationBuilder
    extends OperationBuilder {
        private final ModelNode op;

        private CompositeOperationBuilder(ModelNode op) {
            super(op);
            this.op = op;
        }

        private CompositeOperationBuilder(ModelNode op, boolean autoCloseStreams) {
            super(op, autoCloseStreams);
            this.op = op;
        }

        public static CompositeOperationBuilder create() {
            return new CompositeOperationBuilder(Operations.createCompositeOperation());
        }

        public static CompositeOperationBuilder create(boolean autoCloseStreams) {
            return new CompositeOperationBuilder(Operations.createCompositeOperation(), autoCloseStreams);
        }

        public CompositeOperationBuilder addStep(ModelNode op) {
            this.op.get("steps").add(op);
            return this;
        }

        public CompositeOperationBuilder addFileAsAttachment(File file) {
            super.addFileAsAttachment(file);
            return this;
        }

        public CompositeOperationBuilder addInputStream(InputStream in) {
            super.addInputStream(in);
            return this;
        }
    }
}

