/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting.management;

import java.util.List;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.remote.AbstractModelControllerOperationHandlerFactoryService;
import org.jboss.as.controller.remote.ModelControllerClientOperationHandlerFactoryService;
import org.jboss.as.protocol.mgmt.support.ManagementChannelInitialization;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.remoting.management.ManagementChannelOpenListenerService;
import org.jboss.as.remoting.management.ManagementChannelRegistryService;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.remoting3.Endpoint;
import org.xnio.OptionMap;

public final class ManagementRemotingServices
extends RemotingServices {
    public static final ServiceName MANAGEMENT_ENDPOINT = RemotingServices.REMOTING_BASE.append(new String[]{"endpoint", "management"});
    public static final String MANAGEMENT_CHANNEL = "management";
    public static final String DOMAIN_CHANNEL = "domain";
    public static final String SERVER_CHANNEL = "server";
    public static final String MANAGEMENT_CONNECTOR = "management";

    private ManagementRemotingServices() {
    }

    public static void installDomainConnectorServices(ServiceTarget serviceTarget, ServiceName endpointName, ServiceName networkInterfaceBinding, int port, ServiceName securityRealmName, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        ServiceName serverCallbackService = ServiceName.JBOSS.append(new String[]{"host", "controller", "server-inventory", "callback"});
        ServiceName tmpDirPath = ServiceName.JBOSS.append(new String[]{SERVER_CHANNEL, "path", "jboss.domain.temp.dir"});
        ManagementRemotingServices.installSecurityServices(serviceTarget, "management", securityRealmName, serverCallbackService, tmpDirPath, verificationHandler, newControllers);
        ManagementRemotingServices.installConnectorServicesForNetworkInterfaceBinding(serviceTarget, endpointName, "management", networkInterfaceBinding, port, OptionMap.EMPTY, verificationHandler, newControllers);
    }

    public static void installManagementChannelOpenListenerService(ServiceTarget serviceTarget, ServiceName endpointName, String channelName, ServiceName operationHandlerName, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        ManagementRemotingServices.installManagementChannelOpenListenerService(serviceTarget, endpointName, channelName, operationHandlerName, verificationHandler, newControllers, false);
    }

    public static void installManagementChannelOpenListenerService(ServiceTarget serviceTarget, ServiceName endpointName, String channelName, ServiceName operationHandlerName, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers, boolean onDemand) {
        ManagementChannelOpenListenerService channelOpenListenerService = new ManagementChannelOpenListenerService(channelName, OptionMap.EMPTY);
        ServiceBuilder builder = serviceTarget.addService(channelOpenListenerService.getServiceName(endpointName), (Service)channelOpenListenerService).addDependency(endpointName, Endpoint.class, channelOpenListenerService.getEndpointInjector()).addDependency(operationHandlerName, ManagementChannelInitialization.class, channelOpenListenerService.getOperationHandlerInjector()).addDependency(ManagementChannelRegistryService.SERVICE_NAME, ManagementChannelRegistryService.class, channelOpenListenerService.getRegistry()).setInitialMode(onDemand ? ServiceController.Mode.ON_DEMAND : ServiceController.Mode.ACTIVE);
        ManagementRemotingServices.addController(newControllers, verificationHandler, builder);
    }

    public static void removeManagementChannelOpenListenerService(OperationContext context, ServiceName endpointName, String channelName) {
        context.removeService(RemotingServices.channelServiceName(endpointName, channelName));
    }

    public static void installManagementChannelServices(ServiceTarget serviceTarget, ServiceName endpointName, AbstractModelControllerOperationHandlerFactoryService operationHandlerService, ServiceName modelControllerName, String channelName, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        ServiceName operationHandlerName = endpointName.append(new String[]{channelName}).append(ModelControllerClientOperationHandlerFactoryService.OPERATION_HANDLER_NAME_SUFFIX);
        ServiceBuilder builder = serviceTarget.addService(operationHandlerName, (Service)operationHandlerService).addDependency(modelControllerName, ModelController.class, (Injector)operationHandlerService.getModelControllerInjector()).setInitialMode(ServiceController.Mode.ACTIVE);
        ManagementRemotingServices.addController(newControllers, verificationHandler, builder);
        ManagementRemotingServices.installManagementChannelOpenListenerService(serviceTarget, endpointName, channelName, operationHandlerName, verificationHandler, newControllers);
    }

    public static void removeManagementChannelServices(OperationContext context, ServiceName endpointName, String channelName) {
        ManagementRemotingServices.removeManagementChannelOpenListenerService(context, endpointName, channelName);
        ServiceName operationHandlerName = endpointName.append(new String[]{channelName}).append(ModelControllerClientOperationHandlerFactoryService.OPERATION_HANDLER_NAME_SUFFIX);
        context.removeService(operationHandlerName);
    }
}

