/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.remoting.AbstractOutboundConnectionAddHandler;
import org.jboss.as.remoting.AbstractOutboundConnectionResourceDefinition;
import org.jboss.as.remoting.GenericOutboundConnectionAdd;
import org.jboss.as.remoting.GenericOutboundConnectionResourceDefinition;
import org.jboss.as.remoting.GenericOutboundConnectionService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

class GenericOutboundConnectionWriteHandler
extends AbstractWriteAttributeHandler<Void> {
    static final GenericOutboundConnectionWriteHandler INSTANCE = new GenericOutboundConnectionWriteHandler();

    private GenericOutboundConnectionWriteHandler() {
        super(new AttributeDefinition[]{AbstractOutboundConnectionResourceDefinition.CONNECTION_CREATION_OPTIONS, GenericOutboundConnectionResourceDefinition.URI});
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> voidHandbackHolder) throws OperationFailedException {
        ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        this.applyModelToRuntime(context, operation, attributeName, model);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        ModelNode restored = context.readResource(PathAddress.EMPTY_ADDRESS).getModel().clone();
        restored.get(attributeName).set(valueToRestore);
        this.applyModelToRuntime(context, operation, attributeName, restored);
    }

    private void applyModelToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode model) throws OperationFailedException {
        String connectionName = PathAddress.pathAddress((ModelNode)operation.get("address")).getLastElement().getValue();
        ServiceName serviceName = GenericOutboundConnectionService.OUTBOUND_CONNECTION_BASE_SERVICE_NAME.append(new String[]{connectionName});
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController sc = registry.getService(serviceName);
        if (sc != null && sc.getState() == ServiceController.State.UP) {
            GenericOutboundConnectionService svc = (GenericOutboundConnectionService)GenericOutboundConnectionService.class.cast(sc.getValue());
            if (AbstractOutboundConnectionResourceDefinition.CONNECTION_CREATION_OPTIONS.getName().equals(attributeName)) {
                svc.setConnectionCreationOptions(AbstractOutboundConnectionAddHandler.getConnectionCreationOptions(model));
            } else if (GenericOutboundConnectionResourceDefinition.URI.getName().equals(attributeName)) {
                svc.setDestination(GenericOutboundConnectionAdd.INSTANCE.getDestinationURI(context, model));
            }
        } else {
            context.removeService(serviceName);
            GenericOutboundConnectionAdd.INSTANCE.installRuntimeService(context, connectionName, model, null);
        }
    }
}

