/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.OpenListener;
import org.jboss.remoting3.Registration;
import org.xnio.OptionMap;

public abstract class AbstractChannelOpenListenerService<T>
implements Service<Void>,
OpenListener {
    protected final Logger log = Logger.getLogger((String)"org.jboss.as.remoting");
    private final InjectedValue<Endpoint> endpointValue = new InjectedValue();
    protected final String channelName;
    private final OptionMap optionMap;
    private final Set<T> channels = Collections.synchronizedSet(new HashSet());
    private volatile Registration registration;
    private final AtomicBoolean closed = new AtomicBoolean();

    public AbstractChannelOpenListenerService(String channelName, OptionMap optionMap) {
        this.channelName = channelName;
        this.optionMap = optionMap;
    }

    public ServiceName getServiceName(ServiceName endpointName) {
        return RemotingServices.channelServiceName(endpointName, this.channelName);
    }

    public InjectedValue<Endpoint> getEndpointInjector() {
        return this.endpointValue;
    }

    public Void getValue() throws IllegalStateException, IllegalArgumentException {
        return null;
    }

    public void start(StartContext context) throws StartException {
        try {
            this.closed.set(false);
            this.log.debugf("Registering channel listener for %s", (Object)this.channelName);
            this.registration = ((Endpoint)this.endpointValue.getValue()).registerService(this.channelName, (OpenListener)this, this.optionMap);
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(StopContext context) {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        if (this.registration != null) {
            this.registration.close();
        }
        Set<T> set = this.channels;
        synchronized (set) {
            HashSet<T> copy = new HashSet<T>(this.channels);
            for (Object channel : copy) {
                this.closeChannelOnShutdown(channel);
            }
        }
    }

    public void channelOpened(Channel channel) {
        final T createdChannel = this.createChannel(channel);
        this.channels.add(createdChannel);
        channel.addCloseHandler((CloseHandler)new CloseHandler<Channel>(){

            public void handleClose(Channel closed, IOException exception) {
                AbstractChannelOpenListenerService.this.channels.remove(createdChannel);
                AbstractChannelOpenListenerService.this.log.tracef("Handling close for %s", createdChannel);
            }
        });
    }

    public void registrationTerminated() {
    }

    protected abstract T createChannel(Channel var1);

    protected abstract void closeChannelOnShutdown(T var1);
}

