/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.embedded.ejb3;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.ejb.EJBException;
import javax.ejb.embeddable.EJBContainer;
import javax.ejb.spi.EJBContainerProvider;
import org.jboss.as.embedded.EmbeddedMessages;
import org.jboss.as.embedded.EmbeddedServerFactory;
import org.jboss.as.embedded.StandaloneServer;
import org.jboss.as.embedded.ejb3.JBossStandaloneEJBContainer;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;

public class JBossStandaloneEJBContainerProvider
implements EJBContainerProvider {
    private void addEmbeddedExtensionTo(StandaloneServer server) throws IOException {
        ModelNode address = new ModelNode().setEmptyList();
        ModelNode add = new ModelNode();
        add.get("address").set(address).add("extension", "org.jboss.as.embedded");
        add.get("operation").set("add");
        ModelNode result = server.getModelControllerClient().execute(add);
        if (!result.get("outcome").equals((Object)"success")) {
            throw new EJBException(result.asString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EJBContainer createEJBContainer(Map<?, ?> properties) throws EJBException {
        JBossStandaloneEJBContainerProvider.setSystemProperty("org.jboss.as.ejb3.EMBEDDED", "true");
        String jbossHomeKey = "jboss.home";
        String jbossHomeProp = System.getProperty(jbossHomeKey);
        if (jbossHomeProp == null) {
            throw EmbeddedMessages.MESSAGES.systemPropertyNotFound(jbossHomeKey);
        }
        File jbossHomeDir = new File(jbossHomeProp);
        if (!jbossHomeDir.isDirectory()) {
            throw EmbeddedMessages.MESSAGES.invalidJbossHome(jbossHomeDir);
        }
        boolean barren = Boolean.getBoolean("org.jboss.as.embedded.ejb3.BARREN");
        StandaloneServer server = barren ? EmbeddedServerFactory.create(jbossHomeDir, System.getProperties(), System.getenv(), "org.jboss.logmanager") : EmbeddedServerFactory.create(Module.getContextModuleLoader(), jbossHomeDir, System.getProperties(), System.getenv());
        server.start();
        JBossStandaloneEJBContainer container = new JBossStandaloneEJBContainer(server);
        boolean okay = false;
        try {
            container.init(properties);
            okay = true;
            JBossStandaloneEJBContainer jBossStandaloneEJBContainer = container;
            if (!okay) {
                container.close();
            }
            return jBossStandaloneEJBContainer;
        }
        catch (Throwable throwable) {
            try {
                if (!okay) {
                    container.close();
                }
                throw throwable;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new EJBException(e);
            }
        }
    }

    private static String setSystemProperty(final String key, final String value) {
        if (System.getSecurityManager() == null) {
            return System.setProperty(key, value);
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.setProperty(key, value);
            }
        });
    }
}

