/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client.helpers.standalone.impl;

import java.util.concurrent.Future;
import org.jboss.as.controller.client.ControllerClientMessages;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlan;
import org.jboss.as.controller.client.helpers.standalone.InitialDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentPlanResult;
import org.jboss.as.controller.client.helpers.standalone.impl.DeploymentActionImpl;
import org.jboss.as.controller.client.helpers.standalone.impl.DeploymentPlanImpl;
import org.jboss.as.controller.client.helpers.standalone.impl.InitialDeploymentPlanBuilderFactory;
import org.jboss.as.controller.client.helpers.standalone.impl.ServerDeploymentPlanResultFuture;
import org.jboss.dmr.ModelNode;

public abstract class AbstractServerDeploymentManager
implements ServerDeploymentManager {
    protected AbstractServerDeploymentManager() {
    }

    @Override
    public InitialDeploymentPlanBuilder newDeploymentPlan() {
        return InitialDeploymentPlanBuilderFactory.newInitialDeploymentPlanBuilder();
    }

    @Override
    public Future<ServerDeploymentPlanResult> execute(DeploymentPlan plan) {
        if (!(plan instanceof DeploymentPlanImpl)) {
            throw ControllerClientMessages.MESSAGES.cannotUseDeploymentPlan();
        }
        DeploymentPlanImpl planImpl = (DeploymentPlanImpl)plan;
        Operation operation = this.getCompositeOperation(planImpl);
        Future<ModelNode> nodeFuture = this.executeOperation(operation);
        return new ServerDeploymentPlanResultFuture(planImpl, nodeFuture);
    }

    protected abstract Future<ModelNode> executeOperation(Operation var1);

    private Operation getCompositeOperation(DeploymentPlanImpl plan) {
        ModelNode op = new ModelNode();
        op.get("operation").set("composite");
        op.get("address").setEmptyList();
        ModelNode steps = op.get("steps");
        steps.setEmptyList();
        op.get(new String[]{"operation-headers", "rollback-on-runtime-failure"}).set(plan.isGlobalRollback());
        OperationBuilder builder = new OperationBuilder(op);
        int stream = 0;
        for (DeploymentActionImpl action : plan.getDeploymentActionImpls()) {
            ModelNode step = new ModelNode();
            String uniqueName = action.getDeploymentUnitUniqueName();
            switch (action.getType()) {
                case ADD: {
                    this.configureDeploymentOperation(step, "add", uniqueName);
                    step.get("runtime-name").set(action.getNewContentFileName());
                    builder.addInputStream(action.getContentStream());
                    step.get("content").get(0).get("input-stream-index").set(stream++);
                    break;
                }
                case DEPLOY: {
                    this.configureDeploymentOperation(step, "deploy", uniqueName);
                    break;
                }
                case FULL_REPLACE: {
                    step.get("operation").set("full-replace-deployment");
                    step.get("address").setEmptyList();
                    step.get("name").set(uniqueName);
                    step.get("runtime-name").set(action.getNewContentFileName());
                    builder.addInputStream(action.getContentStream());
                    step.get("content").get(0).get("input-stream-index").set(stream++);
                    break;
                }
                case REDEPLOY: {
                    this.configureDeploymentOperation(step, "redeploy", uniqueName);
                    break;
                }
                case REMOVE: {
                    this.configureDeploymentOperation(step, "remove", uniqueName);
                    break;
                }
                case REPLACE: {
                    step.get("operation").set("replace-deployment");
                    step.get("address").setEmptyList();
                    step.get("name").set(uniqueName);
                    step.get("to-replace").set(action.getReplacedDeploymentUnitUniqueName());
                    break;
                }
                case UNDEPLOY: {
                    this.configureDeploymentOperation(step, "undeploy", uniqueName);
                    break;
                }
                default: {
                    throw ControllerClientMessages.MESSAGES.unknownActionType((Object)action.getType());
                }
            }
            steps.add(step);
        }
        return builder.build();
    }

    private void configureDeploymentOperation(ModelNode op, String operationName, String uniqueName) {
        op.get("operation").set(operationName);
        op.get("address").add("deployment", uniqueName);
    }
}

