/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client.impl;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.as.controller.client.MessageSeverity;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementBatchIdManager;
import org.jboss.as.protocol.mgmt.ManagementClientChannelStrategy;
import org.jboss.as.protocol.mgmt.ManagementOperationHandler;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.as.protocol.mgmt.ManagementRequestHandler;
import org.jboss.as.protocol.mgmt.ManagementResponseHandler;
import org.jboss.as.protocol.mgmt.RequestProcessingException;
import org.jboss.as.protocol.old.ProtocolUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.threads.AsyncFuture;

public abstract class AbstractModelControllerClient
implements ModelControllerClient,
ManagementOperationHandler {
    private final Map<Integer, ExecuteRequestContext> activeRequests = Collections.synchronizedMap(new HashMap());
    protected final ExecutorService executor = Executors.newCachedThreadPool();
    final Logger log = Logger.getLogger((String)"org.jboss.as.controller.client");

    @Override
    public void close() throws IOException {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.executor.shutdownNow();
    }

    @Override
    public ModelNode execute(ModelNode operation) throws IOException {
        return this.execute(operation, null);
    }

    @Override
    public ModelNode execute(Operation operation) throws IOException {
        return this.execute(operation, null);
    }

    @Override
    public ModelNode execute(ModelNode operation, OperationMessageHandler messageHandler) throws IOException {
        return this.executeSynch(operation, null, messageHandler);
    }

    @Override
    public ModelNode execute(Operation operation, OperationMessageHandler messageHandler) throws IOException {
        return this.executeSynch(operation.getOperation(), operation, messageHandler);
    }

    @Override
    public AsyncFuture<ModelNode> executeAsync(ModelNode operation, OperationMessageHandler messageHandler) {
        return this.executeAsync(operation, null, messageHandler);
    }

    @Override
    public AsyncFuture<ModelNode> executeAsync(Operation operation, OperationMessageHandler messageHandler) {
        return this.executeAsync(operation.getOperation(), operation, messageHandler);
    }

    public ManagementRequestHandler getRequestHandler(byte id) {
        if (id == 72) {
            return new HandleReportRequestHandler();
        }
        if (id == 76) {
            return new ReadAttachmentInputStreamRequestHandler();
        }
        return null;
    }

    protected abstract ManagementClientChannelStrategy getClientChannelStrategy() throws URISyntaxException, IOException;

    private ModelNode executeSynch(ModelNode operation, OperationAttachments attachments, OperationMessageHandler messageHandler) throws IOException {
        int batchId = ManagementBatchIdManager.DEFAULT.createBatchId();
        try {
            return (ModelNode)new ExecuteRequest(batchId, false, operation, messageHandler, attachments).executeForResult(this.executor, this.getClientChannelStrategy());
        }
        catch (Exception e) {
            ManagementBatchIdManager.DEFAULT.freeBatchId(batchId);
            Throwable cause = e;
            if (e instanceof ExecutionException) {
                cause = e.getCause();
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new IOException(cause);
        }
    }

    private AsyncFuture<ModelNode> executeAsync(ModelNode operation, OperationAttachments attachments, OperationMessageHandler messageHandler) {
        int batchId = ManagementBatchIdManager.DEFAULT.createBatchId();
        try {
            return new DelegatingCancellableAsyncFuture((AsyncFuture<ModelNode>)new ExecuteRequest(batchId, true, operation, messageHandler, attachments).execute(this.executor, this.getClientChannelStrategy()), batchId);
        }
        catch (Exception e) {
            ManagementBatchIdManager.DEFAULT.freeBatchId(batchId);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private class DelegatingCancellableAsyncFuture
    implements AsyncFuture<ModelNode> {
        private final AsyncFuture<ModelNode> delegate;
        private final int batchId;
        private volatile boolean isCancelled;

        public DelegatingCancellableAsyncFuture(AsyncFuture<ModelNode> delegate, int batchId) {
            this.delegate = delegate;
            this.batchId = batchId;
        }

        public AsyncFuture.Status await() throws InterruptedException {
            return this.delegate.await();
        }

        public AsyncFuture.Status await(long timeout, TimeUnit unit) throws InterruptedException {
            return this.delegate.await(timeout, unit);
        }

        public ModelNode getUninterruptibly() throws CancellationException, ExecutionException {
            return (ModelNode)this.delegate.getUninterruptibly();
        }

        public ModelNode getUninterruptibly(long timeout, TimeUnit unit) throws CancellationException, ExecutionException, TimeoutException {
            return (ModelNode)this.delegate.getUninterruptibly(timeout, unit);
        }

        public AsyncFuture.Status awaitUninterruptibly() {
            return this.delegate.awaitUninterruptibly();
        }

        public AsyncFuture.Status awaitUninterruptibly(long timeout, TimeUnit unit) {
            return this.delegate.awaitUninterruptibly(timeout, unit);
        }

        public boolean isDone() {
            return this.delegate.isDone();
        }

        public AsyncFuture.Status getStatus() {
            return this.delegate.getStatus();
        }

        public <A> void addListener(AsyncFuture.Listener<? super ModelNode, A> listener, A attachment) {
            this.delegate.addListener(listener, attachment);
        }

        public ModelNode get() throws InterruptedException, ExecutionException {
            return (ModelNode)this.delegate.get();
        }

        public ModelNode get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return (ModelNode)this.delegate.get(timeout, unit);
        }

        public boolean isCancelled() {
            return this.isCancelled;
        }

        public boolean cancel(boolean interruptionDesired) {
            if (!AbstractModelControllerClient.this.activeRequests.containsKey(this.batchId)) {
                return false;
            }
            try {
                new CancelAsyncRequest().executeForResult(AbstractModelControllerClient.this.executor, AbstractModelControllerClient.this.getClientChannelStrategy());
                if (this.isDone()) {
                    this.isCancelled = false;
                }
                this.isCancelled = true;
                return this.isCancelled;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }

        public void asyncCancel(boolean interruptionDesired) {
            try {
                new CancelAsyncRequest().execute(AbstractModelControllerClient.this.executor, AbstractModelControllerClient.this.getClientChannelStrategy());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private class CancelAsyncRequest
        extends ManagementRequest<Void> {
            public CancelAsyncRequest() {
                super(DelegatingCancellableAsyncFuture.this.batchId);
            }

            protected byte getRequestCode() {
                return 77;
            }

            protected ManagementResponseHandler<Void> getResponseHandler() {
                return ManagementResponseHandler.EMPTY_RESPONSE;
            }
        }
    }

    private static class ExecuteRequestContext {
        final ExecuteRequest executeRequest;
        final OperationMessageHandler messageHandler;
        final OperationAttachments attachments;
        volatile boolean done;

        ExecuteRequestContext(ExecuteRequest executeRequest, OperationMessageHandler messageHandler, OperationAttachments attachments) {
            this.executeRequest = executeRequest;
            this.messageHandler = messageHandler;
            this.attachments = attachments;
        }

        CloseHandler<Channel> getRequestCloseHandler() {
            return new CloseHandler<Channel>(){

                public void handleClose(Channel closed, IOException exception) {
                    if (!ExecuteRequestContext.this.done) {
                        ExecuteRequestContext.this.executeRequest.setError(new IOException("Channel closed"));
                    }
                }
            };
        }

        OperationMessageHandler getMessageHandler() {
            return this.messageHandler;
        }

        OperationAttachments getAttachments() {
            return this.attachments;
        }

        void done() {
            this.done = true;
        }
    }

    private class ReadAttachmentInputStreamRequestHandler
    extends ManagementRequestHandler {
        InputStream attachmentInput;
        byte[] bytes;

        private ReadAttachmentInputStreamRequestHandler() {
        }

        protected void readRequest(DataInput input) throws IOException {
            int batchId = this.getHeader().getBatchId();
            AbstractModelControllerClient.this.log.tracef("Client got inputstream request %d", (Object)batchId);
            ProtocolUtils.expectHeader((DataInput)input, (int)102);
            int index = input.readInt();
            ExecuteRequestContext requestContext = (ExecuteRequestContext)AbstractModelControllerClient.this.activeRequests.get(batchId);
            if (requestContext == null) {
                throw new IOException("No active request found for " + batchId);
            }
            InputStream in = requestContext.getAttachments().getInputStreams().get(index);
            this.attachmentInput = in != null ? new BufferedInputStream(in) : null;
        }

        protected void processRequest() throws RequestProcessingException {
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                if (this.attachmentInput != null) {
                    int i = this.attachmentInput.read();
                    while (i != -1) {
                        bout.write(i);
                        i = this.attachmentInput.read();
                    }
                }
                this.bytes = bout.toByteArray();
            }
            catch (IOException e) {
                throw new RequestProcessingException((Throwable)e);
            }
        }

        protected void writeResponse(FlushableDataOutput output) throws IOException {
            output.write(103);
            output.writeInt(this.bytes.length);
            output.write(104);
            output.write(this.bytes);
            AbstractModelControllerClient.this.log.tracef("Client handled inputstream request %d", (Object)this.getHeader().getBatchId());
        }
    }

    private class HandleReportRequestHandler
    extends ManagementRequestHandler {
        private HandleReportRequestHandler() {
        }

        protected void readRequest(DataInput input) throws IOException {
            int batchId = this.getHeader().getBatchId();
            ProtocolUtils.expectHeader((DataInput)input, (int)98);
            MessageSeverity severity = Enum.valueOf(MessageSeverity.class, input.readUTF());
            ProtocolUtils.expectHeader((DataInput)input, (int)99);
            String message = input.readUTF();
            ExecuteRequestContext requestContext = (ExecuteRequestContext)AbstractModelControllerClient.this.activeRequests.get(batchId);
            if (requestContext == null) {
                throw new IOException("No active request found for " + batchId);
            }
            if (requestContext.getMessageHandler() != null) {
                requestContext.getMessageHandler().handleReport(severity, message);
            }
        }

        protected void processRequest() {
        }
    }

    private class ExecuteRequest
    extends ManagementRequest<ModelNode> {
        private final ExecuteRequestContext executeRequestContext;
        private final ModelNode operation;
        private final boolean async;

        ExecuteRequest(int batchId, boolean async, ModelNode operation, OperationMessageHandler messageHandler, OperationAttachments attachments) {
            super(batchId);
            this.operation = operation;
            this.async = async;
            this.executeRequestContext = new ExecuteRequestContext(this, messageHandler, attachments);
        }

        protected byte getRequestCode() {
            return this.async ? (byte)69 : 70;
        }

        protected CloseHandler<Channel> getRequestCloseHandler() {
            return this.executeRequestContext.getRequestCloseHandler();
        }

        protected void writeRequest(int protocolVersion, FlushableDataOutput output) throws IOException {
            try {
                List<InputStream> streams;
                AbstractModelControllerClient.this.log.tracef("Client writing request %d", (Object)this.getBatchId());
                AbstractModelControllerClient.this.activeRequests.put(this.getBatchId(), this.executeRequestContext);
                output.write(97);
                this.operation.writeExternal((DataOutput)output);
                output.write(101);
                int inputStreamLength = 0;
                if (this.executeRequestContext.getAttachments() != null && (streams = this.executeRequestContext.getAttachments().getInputStreams()) != null) {
                    inputStreamLength = streams.size();
                }
                output.writeInt(inputStreamLength);
                AbstractModelControllerClient.this.log.tracef("Client wrote request %d successfully", (Object)this.getBatchId());
            }
            catch (Exception e) {
                AbstractModelControllerClient.this.log.tracef((Throwable)e, "Client wrote request %d with error", (Object)this.getBatchId());
                this.setError(e);
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new IOException(e);
            }
        }

        protected ManagementResponseHandler<ModelNode> getResponseHandler() {
            return new ManagementResponseHandler<ModelNode>(){

                protected ModelNode readResponse(DataInput input) throws IOException {
                    AbstractModelControllerClient.this.log.tracef("Client reading response %d", (Object)ExecuteRequest.this.getBatchId());
                    try {
                        ProtocolUtils.expectHeader((DataInput)input, (int)100);
                        ModelNode node = new ModelNode();
                        node.readExternal(input);
                        AbstractModelControllerClient.this.log.tracef("Client read response %d successfully", (Object)ExecuteRequest.this.getBatchId());
                        ModelNode modelNode = node;
                        return modelNode;
                    }
                    catch (Exception e) {
                        AbstractModelControllerClient.this.log.tracef((Throwable)e, "Client read response %d with error", (Object)ExecuteRequest.this.getBatchId());
                        ExecuteRequest.this.setError(e);
                        if (e instanceof IOException) {
                            throw (IOException)e;
                        }
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        throw new IOException(e);
                    }
                    finally {
                        ManagementBatchIdManager.DEFAULT.freeBatchId(ExecuteRequest.this.getBatchId());
                        AbstractModelControllerClient.this.activeRequests.remove(ExecuteRequest.this.getBatchId());
                        ExecuteRequest.this.executeRequestContext.done();
                    }
                }
            };
        }

        protected void setError(Exception e) {
            super.setError(e instanceof IOException ? e : new IOException(e));
        }
    }
}

