/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.findby;

import java.lang.annotation.Annotation;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.util.HashSet;
import org.jboss.arquillian.graphene.spi.findby.ImplementsLocationStrategy;
import org.jboss.arquillian.graphene.spi.findby.LocationStrategy;
import org.openqa.selenium.By;
import org.openqa.selenium.support.ByIdOrName;
import org.openqa.selenium.support.CacheLookup;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.FindBys;
import org.openqa.selenium.support.How;
import org.openqa.selenium.support.pagefactory.ByChained;

public class Annotations {
    private final Field field;
    private final How defaultElementLocatingStrategy;

    public Annotations(Field field, How defaultElementLocatingStrategy) {
        this.field = field;
        this.defaultElementLocatingStrategy = defaultElementLocatingStrategy;
    }

    public boolean isLookupCached() {
        return this.field.getAnnotation(CacheLookup.class) != null;
    }

    public By buildBy() {
        this.assertValidAnnotations();
        By by = null;
        by = this.checkAndProcessEmptyFindBy();
        FindBys webDriverFindBys = this.field.getAnnotation(FindBys.class);
        if (by == null && webDriverFindBys != null) {
            by = this.buildByFromFindBys(webDriverFindBys);
        }
        FindBy findBy = this.field.getAnnotation(FindBy.class);
        if (by == null && findBy != null) {
            by = this.buildByFromFindBy(findBy);
        }
        for (Annotation annotation : this.field.getAnnotations()) {
            ImplementsLocationStrategy strategy = annotation.annotationType().getAnnotation(ImplementsLocationStrategy.class);
            if (strategy == null) continue;
            by = this.buildByFromLocationStrategy(strategy, annotation);
        }
        if (by == null) {
            by = this.buildByFromDefault();
        }
        if (by == null) {
            throw new IllegalArgumentException("Cannot determine how to locate element " + this.field);
        }
        return by;
    }

    private By checkAndProcessEmptyFindBy() {
        int numberOfValues;
        By result = null;
        FindBy findBy = this.field.getAnnotation(FindBy.class);
        if (findBy != null && (numberOfValues = this.assertValidFindBy(findBy)) == 0) {
            result = this.buildByFromDefault();
        }
        return result;
    }

    protected By buildByFromDefault() {
        String using = this.field.getName();
        return this.getByFromHow(this.defaultElementLocatingStrategy, using);
    }

    protected By buildByFromLocationStrategy(ImplementsLocationStrategy strategy, Annotation annotation) {
        try {
            LocationStrategy transformer = (LocationStrategy)strategy.value().newInstance();
            return transformer.fromAnnotation(annotation);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot use locationStrategy " + strategy + " on annotation " + annotation + " on field " + this.field + ": " + e.getMessage(), e);
        }
    }

    protected By buildByFromFindBys(FindBys webDriverFindBys) {
        this.assertValidFindBys(webDriverFindBys);
        FindBy[] findByArray = webDriverFindBys.value();
        By[] byArray = new By[findByArray.length];
        for (int i = 0; i < findByArray.length; ++i) {
            byArray[i] = this.buildByFromFindBy(findByArray[i]);
        }
        return new ByChained(byArray);
    }

    protected By buildByFromFindBy(FindBy findBy) {
        this.assertValidFindBy(findBy);
        By ans = this.buildByFromShortFindBy(findBy);
        if (ans == null) {
            ans = this.buildByFromLongFindBy(findBy);
        }
        return ans;
    }

    protected By buildByFromLongFindBy(FindBy findBy) {
        How how = findBy.how();
        String using = findBy.using();
        switch (how) {
            case CLASS_NAME: {
                return By.className((String)using);
            }
            case CSS: {
                return By.cssSelector((String)using);
            }
            case ID: {
                return By.id((String)using);
            }
            case ID_OR_NAME: {
                return new ByIdOrName(using);
            }
            case LINK_TEXT: {
                return By.linkText((String)using);
            }
            case NAME: {
                return By.name((String)using);
            }
            case PARTIAL_LINK_TEXT: {
                return By.partialLinkText((String)using);
            }
            case TAG_NAME: {
                return By.tagName((String)using);
            }
            case XPATH: {
                return By.xpath((String)using);
            }
        }
        throw new IllegalArgumentException("Cannot determine how to locate element " + this.field);
    }

    private By getByFromHow(How how, String using) {
        switch (how) {
            case CLASS_NAME: {
                return By.className((String)using);
            }
            case CSS: {
                return By.cssSelector((String)using);
            }
            case ID: {
                return By.id((String)using);
            }
            case ID_OR_NAME: {
                return new ByIdOrName(using);
            }
            case LINK_TEXT: {
                return By.linkText((String)using);
            }
            case NAME: {
                return By.name((String)using);
            }
            case PARTIAL_LINK_TEXT: {
                return By.partialLinkText((String)using);
            }
            case TAG_NAME: {
                return By.tagName((String)using);
            }
            case XPATH: {
                return By.xpath((String)using);
            }
        }
        throw new IllegalArgumentException("Cannot determine how to locate element " + this.field);
    }

    protected By buildByFromShortFindBy(FindBy findBy) {
        if (!"".equals(findBy.className())) {
            return By.className((String)findBy.className());
        }
        if (!"".equals(findBy.css())) {
            return By.cssSelector((String)findBy.css());
        }
        if (!"".equals(findBy.id())) {
            return By.id((String)findBy.id());
        }
        if (!"".equals(findBy.linkText())) {
            return By.linkText((String)findBy.linkText());
        }
        if (!"".equals(findBy.name())) {
            return By.name((String)findBy.name());
        }
        if (!"".equals(findBy.partialLinkText())) {
            return By.partialLinkText((String)findBy.partialLinkText());
        }
        if (!"".equals(findBy.tagName())) {
            return By.tagName((String)findBy.tagName());
        }
        if (!"".equals(findBy.xpath())) {
            return By.xpath((String)findBy.xpath());
        }
        return null;
    }

    private void assertValidAnnotations() {
        FindBys findBys = this.field.getAnnotation(FindBys.class);
        FindBy findBy = this.field.getAnnotation(FindBy.class);
        if (findBys != null && findBy != null) {
            throw new IllegalArgumentException("If you use a '@FindBys' annotation, you must not also use a '@FindBy' annotation");
        }
    }

    private void assertValidFindBys(FindBys webDriverFindBys) {
        for (FindBy webDriverFindBy : webDriverFindBys.value()) {
            this.assertValidFindBy(webDriverFindBy);
        }
    }

    private int assertValidFindBy(FindBy findBy) {
        if (findBy.how() != null && findBy.using() == null) {
            throw new IllegalArgumentException("If you set the 'how' property, you must also set 'using'");
        }
        HashSet<CallSite> finders = new HashSet<CallSite>();
        if (!"".equals(findBy.using())) {
            finders.add((CallSite)((Object)("how: " + findBy.using())));
        }
        if (!"".equals(findBy.className())) {
            finders.add((CallSite)((Object)("class name:" + findBy.className())));
        }
        if (!"".equals(findBy.css())) {
            finders.add((CallSite)((Object)("css:" + findBy.css())));
        }
        if (!"".equals(findBy.id())) {
            finders.add((CallSite)((Object)("id: " + findBy.id())));
        }
        if (!"".equals(findBy.linkText())) {
            finders.add((CallSite)((Object)("link text: " + findBy.linkText())));
        }
        if (!"".equals(findBy.name())) {
            finders.add((CallSite)((Object)("name: " + findBy.name())));
        }
        if (!"".equals(findBy.partialLinkText())) {
            finders.add((CallSite)((Object)("partial link text: " + findBy.partialLinkText())));
        }
        if (!"".equals(findBy.tagName())) {
            finders.add((CallSite)((Object)("tag name: " + findBy.tagName())));
        }
        if (!"".equals(findBy.xpath())) {
            finders.add((CallSite)((Object)("xpath: " + findBy.xpath())));
        }
        if (finders.size() > 1) {
            throw new IllegalArgumentException(String.format("You must specify at most one location strategy. Number found: %d (%s)", finders.size(), ((Object)finders).toString()));
        }
        return finders.size();
    }
}

