/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.resourceserver.utils.filter;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.resourceserver.aggr.om.Included;
import org.jasig.resourceserver.utils.aggr.ResourcesElementsProvider;
import org.jasig.resourceserver.utils.aggr.ResourcesElementsProviderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.filter.GenericFilterBean;

public class PathBasedCacheExpirationFilter
extends GenericFilterBean {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final DateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", new Locale("en"));
    private Set<Integer> _maxAges;
    private ResourcesElementsProvider resourcesElementsProvider;
    private Map<String, Integer> cacheMaxAges;
    private final AntPathMatcher pathMatcher = new AntPathMatcher();
    private final ConcurrentHashMap<Integer, String> cachedControlStrings = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, String> cachedExpiresStrings = new ConcurrentHashMap();
    private Timer headerUpdateTimer;
    private long regenerateHeadersInterval = 1000L;

    public void setCacheMaxAges(Map<String, Integer> cacheMaxAges) {
        this.cacheMaxAges = cacheMaxAges;
        this._maxAges = new HashSet<Integer>();
        this._maxAges.addAll(cacheMaxAges.values());
    }

    public PathBasedCacheExpirationFilter() {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        this.dateFormat.setTimeZone(timeZone);
    }

    public long getRegenerateHeadersInterval() {
        return this.regenerateHeadersInterval;
    }

    public void setRegenerateHeadersInterval(long regenerateHeadersInterval) {
        if (regenerateHeadersInterval < 1L) {
            throw new IllegalArgumentException("'regenerateHeadersInterval' must be greater than 0, (" + regenerateHeadersInterval + ")");
        }
        this.regenerateHeadersInterval = regenerateHeadersInterval;
    }

    public void setResourcesElementsProvider(ResourcesElementsProvider resourcesElementsProvider) {
        this.resourcesElementsProvider = resourcesElementsProvider;
    }

    protected void initFilterBean() throws ServletException {
        ServletContext servletContext;
        if (this.resourcesElementsProvider == null) {
            servletContext = this.getServletContext();
            this.resourcesElementsProvider = ResourcesElementsProviderUtils.getOrCreateResourcesElementsProvider(servletContext);
        }
        for (Integer age : this._maxAges) {
            this.cachedControlStrings.put(age, "public, max-age=" + age);
        }
        this.updateCacheHeaders();
        servletContext = this.getServletContext();
        String servletContextPath = servletContext.getContextPath();
        this.headerUpdateTimer = new Timer(servletContextPath + "-CacheHeaderUpdateTimer", true);
        this.headerUpdateTimer.schedule((TimerTask)new CacheHeaderUpdater(), this.regenerateHeadersInterval, this.regenerateHeadersInterval);
    }

    public void destroy() {
        this.headerUpdateTimer.cancel();
        this.headerUpdateTimer = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest;
        Included includedType;
        if (response instanceof HttpServletResponse && request instanceof HttpServletRequest && (includedType = this.resourcesElementsProvider.getIncludedType(httpServletRequest = (HttpServletRequest)request)) == Included.AGGREGATED) {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            String path = ((HttpServletRequest)request).getServletPath();
            for (Map.Entry<String, Integer> entry : this.cacheMaxAges.entrySet()) {
                if (!this.pathMatcher.match(entry.getKey(), path)) continue;
                String expires = this.getExpiresHeader(entry.getValue());
                httpResponse.setHeader("Expires", expires);
                httpResponse.setHeader("Cache-Control", this.cachedControlStrings.get(entry.getValue()));
                break;
            }
        }
        chain.doFilter(request, response);
    }

    protected String getExpiresHeader(Integer cacheMaxAge) {
        return this.cachedExpiresStrings.get(cacheMaxAge);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCacheHeaders() {
        for (Integer cacheMaxAge : this._maxAges) {
            DateFormat dateFormat = this.dateFormat;
            synchronized (dateFormat) {
                Calendar cal = Calendar.getInstance();
                cal.add(13, cacheMaxAge);
                this.cachedExpiresStrings.put(cacheMaxAge, this.dateFormat.format(cal.getTime()));
            }
        }
    }

    private final class CacheHeaderUpdater
    extends TimerTask {
        private CacheHeaderUpdater() {
        }

        @Override
        public void run() {
            PathBasedCacheExpirationFilter.this.updateCacheHeaders();
        }
    }
}

