/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.resourceserver.utils.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.resourceserver.aggr.om.Included;
import org.jasig.resourceserver.utils.aggr.ResourcesElementsProvider;
import org.jasig.resourceserver.utils.aggr.ResourcesElementsProviderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.GenericFilterBean;

public class CacheExpirationFilter
extends GenericFilterBean {
    private static final long YEAR_OF_MILLISECONDS = 31536000000L;
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private String cachedControlString;
    private ResourcesElementsProvider resourcesElementsProvider;
    private long cacheMaxAge = 31536000000L;

    public int getCacheMaxAge() {
        return (int)(this.cacheMaxAge / 1000L);
    }

    public void setCacheMaxAge(int cacheMaxAge) {
        if (cacheMaxAge < 1) {
            throw new IllegalArgumentException("Specified initParamter 'cacheMaxAge' must be greater than 0, (" + cacheMaxAge + ")");
        }
        this.cacheMaxAge = cacheMaxAge * 1000;
        this.updateHeaders();
    }

    public void setResourcesElementsProvider(ResourcesElementsProvider resourcesElementsProvider) {
        this.resourcesElementsProvider = resourcesElementsProvider;
    }

    protected void initFilterBean() throws ServletException {
        if (this.resourcesElementsProvider == null) {
            ServletContext servletContext = this.getServletContext();
            this.resourcesElementsProvider = ResourcesElementsProviderUtils.getOrCreateResourcesElementsProvider(servletContext);
        }
        this.updateHeaders();
    }

    private void updateHeaders() {
        this.cachedControlString = "public, max-age=" + this.cacheMaxAge / 1000L;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest;
        Included includedType;
        if (response instanceof HttpServletResponse && request instanceof HttpServletRequest && (includedType = this.resourcesElementsProvider.getIncludedType(httpServletRequest = (HttpServletRequest)request)) == Included.AGGREGATED) {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.setDateHeader("Expires", this.cacheMaxAge + System.currentTimeMillis());
            httpResponse.setHeader("Cache-Control", this.cachedControlString);
        }
        chain.doFilter(request, response);
    }
}

