/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas3.extensions.clearpass.integration.uportal;

import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.util.XmlUtils;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.portal.security.IOpaqueCredentials;
import org.jasig.portal.security.provider.ChainingSecurityContext;
import org.jasig.portal.security.provider.NotSoOpaqueCredentials;
import org.jasig.portal.security.provider.cas.CasAssertionSecurityContext;
import org.springframework.util.Assert;

public final class PasswordCachingCasAssertionSecurityContext
extends CasAssertionSecurityContext {
    private final String clearPassUrl;
    private byte[] cachedCredentials;

    protected PasswordCachingCasAssertionSecurityContext(String clearPassUrl) {
        Assert.notNull((Object)clearPassUrl, (String)"clearPassUrl cannot be null.");
        this.clearPassUrl = clearPassUrl;
    }

    protected void postAuthenticate(Assertion assertion) {
        String proxyTicket = assertion.getPrincipal().getProxyTicketFor(this.clearPassUrl);
        if (proxyTicket == null) {
            this.log.error((Object)"Unable to obtain proxy ticket for ClearPass service.");
            return;
        }
        String password = this.retrievePasswordFromResponse(proxyTicket);
        if (password != null) {
            this.log.debug((Object)"Password retrieved from ClearPass.");
            this.cachedCredentials = password.getBytes();
        } else {
            this.log.debug((Object)"Unable to retrieve password from ClearPass.");
        }
    }

    public IOpaqueCredentials getOpaqueCredentials() {
        if (this.cachedCredentials == null) {
            return super.getOpaqueCredentials();
        }
        CacheOpaqueCredentials credentials = new CacheOpaqueCredentials();
        credentials.setCredentials(this.cachedCredentials);
        return credentials;
    }

    protected final String retrievePasswordFromResponse(String proxyTicket) {
        String url = this.clearPassUrl + (this.clearPassUrl.contains("?") ? "&" : "?") + "ticket=" + proxyTicket;
        String response = CommonUtils.getResponseFromServer((String)url, (String)"UTF-8");
        String password = XmlUtils.getTextForElement((String)response, (String)"credentials");
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("ClearPass Response was:\n %s", response));
        }
        if (CommonUtils.isNotBlank((String)password)) {
            return password;
        }
        this.log.error((Object)("Unable to Retrieve Password.  Full Response from ClearPass was [" + response + "]"));
        return null;
    }

    private class CacheOpaqueCredentials
    extends ChainingSecurityContext.ChainingOpaqueCredentials
    implements NotSoOpaqueCredentials {
        private static final long serialVersionUID = 1L;

        private CacheOpaqueCredentials() {
            super((ChainingSecurityContext)PasswordCachingCasAssertionSecurityContext.this);
        }

        public String getCredentials() {
            return this.credentialstring != null ? new String(this.credentialstring) : null;
        }
    }
}

