/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.impl.TransactionTable;
import org.testng.AssertJUnit;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.LocalModeTxTest")
public class LocalModeTxTest
extends SingleCacheManagerTest {
    protected StorageType storage;

    @Factory
    public Object[] factory() {
        return new Object[]{new LocalModeTxTest().withStorage(StorageType.BINARY), new LocalModeTxTest().withStorage(StorageType.OBJECT), new LocalModeTxTest().withStorage(StorageType.OFF_HEAP)};
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() {
        ConfigurationBuilder configuration = this.getDefaultStandaloneCacheConfig(true);
        configuration.memory().storageType(this.storage);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(configuration);
        this.cache = cm.getCache();
        return cm;
    }

    public LocalModeTxTest withStorage(StorageType storage) {
        this.storage = storage;
        return this;
    }

    @Override
    protected String parameters() {
        return "[storage=" + String.valueOf(this.storage) + "]";
    }

    public void testTxCommit1() throws Exception {
        TransactionManager tm = TestingUtil.getTransactionManager(this.cache);
        tm.begin();
        this.cache.put((Object)"key", (Object)"value");
        Transaction t = tm.suspend();
        AssertJUnit.assertTrue((boolean)this.cache.isEmpty());
        tm.resume(t);
        tm.commit();
        AssertJUnit.assertFalse((boolean)this.cache.isEmpty());
    }

    public void testTxCommit3() throws Exception {
        TransactionManager tm = TestingUtil.getTransactionManager(this.cache);
        tm.begin();
        this.cache.put((Object)"key", (Object)"value");
        tm.commit();
        AssertJUnit.assertFalse((boolean)this.cache.isEmpty());
    }

    public void testNonTx() throws Exception {
        this.cache.put((Object)"key", (Object)"value");
        AssertJUnit.assertFalse((boolean)this.cache.isEmpty());
    }

    public void testTxCommit2() throws Exception {
        TransactionManager tm = TestingUtil.getTransactionManager(this.cache);
        this.cache.put((Object)"key", (Object)"old");
        tm.begin();
        AssertJUnit.assertEquals((Object)"old", (Object)this.cache.get((Object)"key"));
        this.cache.put((Object)"key", (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache.get((Object)"key"));
        Transaction t = tm.suspend();
        AssertJUnit.assertEquals((Object)"old", (Object)this.cache.get((Object)"key"));
        tm.resume(t);
        tm.commit();
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache.get((Object)"key"));
        AssertJUnit.assertFalse((boolean)this.cache.isEmpty());
    }

    public void testKeySet() throws Exception {
        this.tm().begin();
        this.cache.put((Object)"k1", (Object)"v1");
        this.cache.put((Object)"k2", (Object)"v2");
        AssertJUnit.assertEquals((int)2, (int)this.cache.keySet().size());
        AssertJUnit.assertEquals((int)2, (int)this.cache.values().size());
        this.tm().commit();
        AssertJUnit.assertEquals((int)2, (int)this.cache.keySet().size());
        AssertJUnit.assertEquals((int)2, (int)this.cache.values().size());
    }

    public void testKeySet2() throws Exception {
        this.cache.put((Object)"k1", (Object)"v1");
        this.cache.put((Object)"k2", (Object)"v2");
        AssertJUnit.assertEquals((int)2, (int)this.cache.keySet().size());
        AssertJUnit.assertEquals((int)2, (int)this.cache.values().size());
        this.tm().begin();
        AssertJUnit.assertEquals((int)2, (int)this.cache.keySet().size());
        AssertJUnit.assertEquals((int)2, (int)this.cache.values().size());
        this.cache.remove((Object)"k1");
        AssertJUnit.assertEquals((int)1, (int)this.cache.keySet().size());
        AssertJUnit.assertEquals((int)1, (int)this.cache.values().size());
        this.tm().rollback();
        AssertJUnit.assertEquals((int)2, (int)this.cache.keySet().size());
        AssertJUnit.assertEquals((int)2, (int)this.cache.values().size());
    }

    public void testKeySetAlterValue() throws Exception {
        this.cache.put((Object)"k1", (Object)"v1");
        this.cache.put((Object)"k2", (Object)"v2");
        AssertJUnit.assertEquals((int)2, (int)this.cache.keySet().size());
        AssertJUnit.assertEquals((int)2, (int)this.cache.values().size());
        this.tm().begin();
        AssertJUnit.assertEquals((int)2, (int)this.cache.keySet().size());
        AssertJUnit.assertEquals((int)2, (int)this.cache.values().size());
        this.cache.put((Object)"k1", (Object)"v3");
        AssertJUnit.assertEquals((int)2, (int)this.cache.keySet().size());
        AssertJUnit.assertEquals((int)2, (int)this.cache.values().size());
        assert (this.cache.values().contains((Object)"v3"));
        this.tm().rollback();
        AssertJUnit.assertEquals((int)2, (int)this.cache.keySet().size());
        AssertJUnit.assertEquals((int)2, (int)this.cache.values().size());
    }

    public void testTxCleanupWithKeySet() throws Exception {
        this.tm().begin();
        AssertJUnit.assertEquals((int)0, (int)this.cache.keySet().size());
        TransactionTable txTable = TestingUtil.getTransactionTable(this.cache);
        AssertJUnit.assertEquals((int)1, (int)txTable.getLocalTransactions().size());
        this.tm().commit();
        AssertJUnit.assertEquals((int)0, (int)txTable.getLocalTransactions().size());
    }

    public void testTxCleanupWithEntrySet() throws Exception {
        this.tm().begin();
        AssertJUnit.assertEquals((int)0, (int)this.cache.entrySet().size());
        TransactionTable txTable = TestingUtil.getTransactionTable(this.cache);
        AssertJUnit.assertEquals((int)1, (int)txTable.getLocalTransactions().size());
        this.tm().commit();
        AssertJUnit.assertEquals((int)0, (int)txTable.getLocalTransactions().size());
    }

    public void testTxCleanupWithValues() throws Exception {
        this.tm().begin();
        AssertJUnit.assertEquals((int)0, (int)this.cache.values().size());
        TransactionTable txTable = TestingUtil.getTransactionTable(this.cache);
        AssertJUnit.assertEquals((int)1, (int)txTable.getLocalTransactions().size());
        this.tm().commit();
        AssertJUnit.assertEquals((int)0, (int)txTable.getLocalTransactions().size());
    }

    public void testTxCleanupWithSize() throws Exception {
        this.tm().begin();
        AssertJUnit.assertEquals((int)0, (int)this.cache.size());
        TransactionTable txTable = TestingUtil.getTransactionTable(this.cache);
        AssertJUnit.assertEquals((int)1, (int)txTable.getLocalTransactions().size());
        this.tm().commit();
        AssertJUnit.assertEquals((int)0, (int)txTable.getLocalTransactions().size());
    }
}

