/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.lang.invoke.CallSite;
import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.BaseCustomAsyncInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="statetransfer.NonTxStateTransferInvalidationTest")
@CleanupAfterMethod
public class NonTxStateTransferInvalidationTest
extends MultipleCacheManagersTest {
    public static final int NUM_KEYS = 10;
    private ConfigurationBuilder dccc;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.dccc = NonTxStateTransferInvalidationTest.getDefaultClusteredCacheConfig(CacheMode.INVALIDATION_SYNC, false, true);
        this.createCluster(this.dccc, 2);
        this.waitForClusterToForm();
    }

    public void testStateTransferDisabled() throws Exception {
        HashSet<CallSite> keys = new HashSet<CallSite>();
        for (int i = 0; i < 10; ++i) {
            String string = "key" + i;
            keys.add((CallSite)((Object)string));
            this.cache(0).put((Object)string, (Object)string);
        }
        log.trace((Object)"State transfer happens here");
        this.addClusterEnabledCacheManager(this.dccc);
        this.waitForClusterToForm();
        log.trace((Object)"Checking the values from caches...");
        for (Object e : keys) {
            log.tracef("Checking key: %s", e);
            InternalCacheEntry d0 = this.advancedCache(0).getDataContainer().get(e);
            InternalCacheEntry d1 = this.advancedCache(1).getDataContainer().get(e);
            InternalCacheEntry d2 = this.advancedCache(2).getDataContainer().get(e);
            AssertJUnit.assertEquals(e, (Object)d0.getValue());
            AssertJUnit.assertNull((Object)d1);
            AssertJUnit.assertNull((Object)d2);
        }
    }

    public void testConfigValidation() {
        ConfigurationBuilder builder1 = new ConfigurationBuilder();
        builder1.clustering().cacheMode(CacheMode.INVALIDATION_ASYNC).stateTransfer();
        builder1.validate();
        ConfigurationBuilder builder2 = new ConfigurationBuilder();
        builder2.clustering().cacheMode(CacheMode.INVALIDATION_ASYNC).stateTransfer().fetchInMemoryState(true);
        Exceptions.expectException(CacheConfigurationException.class, () -> ((ConfigurationBuilder)builder2).validate());
        ConfigurationBuilder builder3 = new ConfigurationBuilder();
        builder3.clustering().cacheMode(CacheMode.INVALIDATION_ASYNC).persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class);
        builder3.validate();
    }

    public void testInvalidationDuringStateTransfer() throws Exception {
        EmbeddedCacheManager node1 = this.manager(0);
        Cache node1Cache = node1.getCache();
        EmbeddedCacheManager node2 = this.manager(1);
        Cache node2Cache = node2.getCache();
        final CountDownLatch latch = new CountDownLatch(1);
        TestingUtil.extractInterceptorChain(node2Cache).addInterceptor((AsyncInterceptor)new BaseCustomAsyncInterceptor(this){
            final /* synthetic */ NonTxStateTransferInvalidationTest this$0;
            {
                this.this$0 = this$0;
            }

            public Object visitInvalidateCommand(InvocationContext ctx, InvalidateCommand command) throws Throwable {
                latch.await(10L, TimeUnit.SECONDS);
                return super.visitInvalidateCommand(ctx, command);
            }
        }, 0);
        String key = "key";
        Future<Void> future = this.fork(() -> {
            node1Cache.putForExternalRead((Object)key, new Object());
            node1Cache.remove((Object)key);
        });
        EmbeddedCacheManager node3 = this.addClusterEnabledCacheManager(this.dccc);
        Cache node3Cache = node3.getCache();
        TestingUtil.waitForNoRebalance(this.caches());
        log.info((Object)"Node 3 started");
        latch.countDown();
        future.get(30L, TimeUnit.SECONDS);
        AssertJUnit.assertNull((Object)node1Cache.get((Object)key));
        AssertJUnit.assertNull((Object)node2Cache.get((Object)key));
        AssertJUnit.assertNull((Object)node3Cache.get((Object)key));
    }
}

