/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.InboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.impl.MapResponseCollector;
import org.infinispan.remoting.transport.jgroups.JGroupsAddressCache;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.ByteString;
import org.infinispan.xsite.commands.remote.XSiteRequest;
import org.jgroups.View;
import org.jgroups.util.UUID;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="remoting.transport.jgroups.JGroupsTransportTest")
public class JGroupsTransportTest
extends MultipleCacheManagersTest {
    public static final ByteString CACHE_NAME = ByteString.fromString((String)"cache");

    @Override
    protected void createCacheManagers() throws Throwable {
        this.addClusterEnabledCacheManager(this.globalBuilder(), this.cacheBuilder());
        this.addClusterEnabledCacheManager(this.globalBuilder(), this.cacheBuilder());
    }

    private ConfigurationBuilder cacheBuilder() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.REPL_SYNC);
        return builder;
    }

    private GlobalConfigurationBuilder globalBuilder() {
        GlobalConfigurationBuilder builder = this.defaultGlobalConfigurationBuilder();
        builder.transport().transport((Transport)new ExposedJGroupsTransport());
        return builder;
    }

    public void testSynchronousIgnoreLeaversInvocationToNonMembers() throws Exception {
        UUID randomUuid = UUID.randomUUID();
        Address randomAddress = JGroupsAddressCache.fromJGroupsAddress((org.jgroups.Address)randomUuid);
        JGroupsTransport transport = (JGroupsTransport)TestingUtil.extractGlobalComponent((CacheContainer)this.manager(0), Transport.class);
        long initialMessages = transport.getChannel().getProtocolStack().getTransport().getMessageStats().getNumMsgsSent();
        ClusteredGetCommand command = new ClusteredGetCommand((Object)"key", CACHE_NAME, Integer.valueOf(0), 0L);
        CompletableFuture future = transport.invokeRemotelyAsync(Collections.singletonList(randomAddress), (ReplicableCommand)command, ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS, 1L, null, DeliverOrder.NONE, true);
        AssertJUnit.assertEquals((Object)CacheNotFoundResponse.INSTANCE, ((Map)future.get()).get(randomAddress));
        AssertJUnit.assertEquals((long)initialMessages, (long)transport.getChannel().getProtocolStack().getTransport().getMessageStats().getNumMsgsSent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeCommandStaggeredToNonMember() throws Exception {
        UUID randomUuid = UUID.randomUUID();
        Address randomAddress = JGroupsAddressCache.fromJGroupsAddress((org.jgroups.Address)randomUuid);
        JGroupsTransport transport = (JGroupsTransport)TestingUtil.extractGlobalComponent((CacheContainer)this.manager(0), Transport.class);
        ClusteredGetCommand command = new ClusteredGetCommand((Object)"key", CACHE_NAME, Integer.valueOf(0), 0L);
        CompletionStage future = transport.invokeCommandStaggered(Collections.singletonList(randomAddress), (ReplicableCommand)command, (ResponseCollector)MapResponseCollector.ignoreLeavers(), DeliverOrder.NONE, 5L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals(Collections.singletonMap(randomAddress, CacheNotFoundResponse.INSTANCE), future.toCompletableFuture().get());
        CompletionStage future2 = transport.invokeCommandStaggered(Arrays.asList(this.address(1), randomAddress), (ReplicableCommand)command, (ResponseCollector)MapResponseCollector.ignoreLeavers(), DeliverOrder.NONE, 5L, TimeUnit.SECONDS);
        Map expected = TestingUtil.mapOf(this.address(1), CacheNotFoundResponse.INSTANCE, randomAddress, CacheNotFoundResponse.INSTANCE);
        AssertJUnit.assertEquals(expected, future2.toCompletableFuture().get());
        CompletableFuture<Void> blocker = this.blockRemoteGets();
        try {
            CompletionStage future3 = transport.invokeCommandStaggered(Arrays.asList(this.address(1), randomAddress), (ReplicableCommand)command, (ResponseCollector)MapResponseCollector.ignoreLeavers(), DeliverOrder.NONE, 5L, TimeUnit.SECONDS);
            Thread.sleep(500L);
            blocker.complete(null);
            AssertJUnit.assertEquals(expected, future3.toCompletableFuture().get());
        }
        finally {
            blocker.complete(null);
        }
    }

    public void testOutOfOrderView() {
        Transport transport = TestingUtil.extractGlobalComponent((CacheContainer)this.manager(0), Transport.class);
        AssertJUnit.assertTrue((boolean)(transport instanceof ExposedJGroupsTransport));
        ExposedJGroupsTransport exposedTransport = (ExposedJGroupsTransport)transport;
        long viewId = transport.getViewId();
        org.jgroups.Address creator = exposedTransport.getJGroupsViewCreator();
        exposedTransport.receiveClusterView(View.create((org.jgroups.Address)creator, (long)(viewId + 1L), (org.jgroups.Address[])new org.jgroups.Address[]{creator}), true);
        AssertJUnit.assertEquals((long)viewId, (long)transport.getViewId());
        exposedTransport.receiveClusterView(View.create((org.jgroups.Address)creator, (long)(viewId - 1L), (org.jgroups.Address[])new org.jgroups.Address[]{creator}), true);
        AssertJUnit.assertEquals((long)viewId, (long)transport.getViewId());
        exposedTransport.receiveClusterView(View.create((org.jgroups.Address)creator, (long)(viewId - 1L), (org.jgroups.Address[])new org.jgroups.Address[]{creator}), false);
        AssertJUnit.assertEquals((long)viewId, (long)transport.getViewId());
    }

    private CompletableFuture<Void> blockRemoteGets() {
        final CompletableFuture<Void> blocker = new CompletableFuture<Void>();
        final InboundInvocationHandler oldInvocationHandler = TestingUtil.extractGlobalComponent((CacheContainer)this.manager(1), InboundInvocationHandler.class);
        InboundInvocationHandler blockingInvocationHandler = new InboundInvocationHandler(){
            final /* synthetic */ JGroupsTransportTest this$0;
            {
                this.this$0 = this$0;
            }

            public void handleFromCluster(Address origin, ReplicableCommand command, Reply reply, DeliverOrder order) {
                if (command instanceof ClusteredGetCommand) {
                    log.tracef("Blocking clustered get", new Object[0]);
                    blocker.thenRun(() -> oldInvocationHandler.handleFromCluster(origin, command, reply, order));
                } else {
                    oldInvocationHandler.handleFromCluster(origin, command, reply, order);
                }
            }

            public void handleFromRemoteSite(String origin, XSiteRequest<?> command, Reply reply, DeliverOrder order) {
                oldInvocationHandler.handleFromRemoteSite(origin, command, reply, order);
            }
        };
        TestingUtil.replaceComponent((CacheContainer)this.manager(1), InboundInvocationHandler.class, blockingInvocationHandler, true);
        return blocker;
    }

    public static class ExposedJGroupsTransport
    extends JGroupsTransport {
        public void receiveClusterView(View newView, boolean installIfFirst) {
            super.receiveClusterView(newView, installIfFirst);
        }

        public org.jgroups.Address getJGroupsViewCreator() {
            return this.channel.getView().getViewId().getCreator();
        }
    }
}

