/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.support;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import jakarta.transaction.Transaction;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import org.infinispan.commons.test.BlockHoundHelper;
import org.infinispan.commons.util.IntSet;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.NonBlockingStore;
import org.infinispan.persistence.support.WaitDelegatingNonBlockingStore;
import org.reactivestreams.Publisher;

public class EnsureNonBlockingStore<K, V>
extends WaitDelegatingNonBlockingStore<K, V> {
    public EnsureNonBlockingStore(NonBlockingStore<K, V> delegate, KeyPartitioner keyPartitioner) {
        super(delegate, keyPartitioner);
    }

    public CompletionStage<Void> start(InitializationContext ctx) {
        return (CompletionStage)BlockHoundHelper.ensureNonBlocking(() -> this.delegate().start(ctx));
    }

    public CompletionStage<Void> stop() {
        return (CompletionStage)BlockHoundHelper.ensureNonBlocking(() -> this.delegate().stop());
    }

    public CompletionStage<Boolean> isAvailable() {
        return (CompletionStage)BlockHoundHelper.ensureNonBlocking(() -> this.delegate().isAvailable());
    }

    public CompletionStage<MarshallableEntry<K, V>> load(int segment, Object key) {
        return (CompletionStage)BlockHoundHelper.ensureNonBlocking(() -> this.delegate().load(segment, key));
    }

    public CompletionStage<Boolean> containsKey(int segment, Object key) {
        return (CompletionStage)BlockHoundHelper.ensureNonBlocking(() -> this.delegate().containsKey(segment, key));
    }

    public CompletionStage<Void> write(int segment, MarshallableEntry<? extends K, ? extends V> entry) {
        return (CompletionStage)BlockHoundHelper.ensureNonBlocking(() -> this.delegate().write(segment, entry));
    }

    public CompletionStage<Boolean> delete(int segment, Object key) {
        return (CompletionStage)BlockHoundHelper.ensureNonBlocking(() -> this.delegate().delete(segment, key));
    }

    public CompletionStage<Void> addSegments(IntSet segments) {
        return (CompletionStage)BlockHoundHelper.ensureNonBlocking(() -> this.delegate().addSegments(segments));
    }

    public CompletionStage<Void> removeSegments(IntSet segments) {
        return (CompletionStage)BlockHoundHelper.ensureNonBlocking(() -> this.delegate().removeSegments(segments));
    }

    public CompletionStage<Void> clear() {
        return (CompletionStage)BlockHoundHelper.ensureNonBlocking(() -> this.delegate().clear());
    }

    public CompletionStage<Void> batch(int publisherCount, Publisher<NonBlockingStore.SegmentedPublisher<Object>> removePublisher, Publisher<NonBlockingStore.SegmentedPublisher<MarshallableEntry<K, V>>> writePublisher) {
        return (CompletionStage)BlockHoundHelper.ensureNonBlocking(() -> this.delegate().batch(publisherCount, removePublisher, writePublisher));
    }

    public CompletionStage<Long> size(IntSet segments) {
        return (CompletionStage)BlockHoundHelper.ensureNonBlocking(() -> this.delegate().size(segments));
    }

    public CompletionStage<Long> approximateSize(IntSet segments) {
        return (CompletionStage)BlockHoundHelper.ensureNonBlocking(() -> this.delegate().approximateSize(segments));
    }

    public Publisher<MarshallableEntry<K, V>> publishEntries(IntSet segments, Predicate<? super K> filter, boolean includeValues) {
        return (Publisher)BlockHoundHelper.ensureNonBlocking(() -> Flowable.fromPublisher((Publisher)this.delegate().publishEntries(segments, filter, includeValues)).subscribeOn(Schedulers.from((Executor)BlockHoundHelper.ensureNonBlockingExecutor())));
    }

    public Publisher<K> publishKeys(IntSet segments, Predicate<? super K> filter) {
        return (Publisher)BlockHoundHelper.ensureNonBlocking(() -> Flowable.fromPublisher((Publisher)this.delegate().publishKeys(segments, filter)).subscribeOn(Schedulers.from((Executor)BlockHoundHelper.ensureNonBlockingExecutor())));
    }

    public Publisher<MarshallableEntry<K, V>> purgeExpired() {
        return (Publisher)BlockHoundHelper.ensureNonBlocking(() -> this.delegate().purgeExpired());
    }

    public CompletionStage<Void> prepareWithModifications(Transaction transaction, int publisherCount, Publisher<NonBlockingStore.SegmentedPublisher<Object>> removePublisher, Publisher<NonBlockingStore.SegmentedPublisher<MarshallableEntry<K, V>>> writePublisher) {
        return (CompletionStage)BlockHoundHelper.ensureNonBlocking(() -> this.delegate().prepareWithModifications(transaction, publisherCount, removePublisher, writePublisher));
    }

    public CompletionStage<Void> commit(Transaction transaction) {
        return (CompletionStage)BlockHoundHelper.ensureNonBlocking(() -> this.delegate().commit(transaction));
    }

    public CompletionStage<Void> rollback(Transaction transaction) {
        return (CompletionStage)BlockHoundHelper.ensureNonBlocking(() -> this.delegate().rollback(transaction));
    }
}

