/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partitionhandling;

import jakarta.transaction.TransactionManager;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.distribution.MagicKey;
import org.infinispan.partitionhandling.AvailabilityException;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.BasePartitionHandlingTest;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="partitionhandling.LockPartitionHandlingTest")
public class LockPartitionHandlingTest
extends BasePartitionHandlingTest {
    public LockPartitionHandlingTest() {
        this.transactional = true;
        this.lockingMode = LockingMode.PESSIMISTIC;
    }

    public void testLockWhenDegraded() throws Exception {
        Cache c0 = this.cache(0);
        MagicKey key = new MagicKey("key1", this.cache(1), this.cache(2));
        c0.put((Object)key, (Object)"value");
        c0.put((Object)new MagicKey("key2", this.cache(2), this.cache(0)), (Object)"value");
        this.splitCluster({0, 1}, {2, 3});
        this.partition(0).assertDegradedMode();
        TransactionManager tm = c0.getAdvancedCache().getTransactionManager();
        tm.begin();
        Exceptions.expectException(AvailabilityException.class, () -> c0.getAdvancedCache().lock((Object[])new MagicKey[]{key}));
        tm.rollback();
    }

    public void testLockSucceedWhenLocal() throws Exception {
        Cache c0 = this.cache(0);
        MagicKey key = new MagicKey("key1", c0, this.cache(1));
        c0.put((Object)key, (Object)"value");
        c0.put((Object)new MagicKey("key2", this.cache(2), this.cache(0)), (Object)"value");
        this.splitCluster({0, 1}, {2, 3});
        this.partition(0).assertDegradedMode();
        TransactionManager tm = c0.getAdvancedCache().getTransactionManager();
        tm.begin();
        AssertJUnit.assertTrue((boolean)c0.getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL).lock((Object[])new MagicKey[]{key}));
        tm.rollback();
    }

    public void testLockSucceedWhenAllMembersInPartition() throws Exception {
        Cache c0 = this.cache(0);
        Cache c1 = this.cache(1);
        MagicKey local = new MagicKey("key1", c0, c1);
        MagicKey remote = new MagicKey("key2", this.cache(2), this.cache(3));
        c0.put((Object)local, (Object)"value");
        c0.put((Object)remote, (Object)"value");
        this.splitCluster({0, 1}, {2, 3});
        this.partition(0).assertDegradedMode();
        TransactionManager tm = c0.getAdvancedCache().getTransactionManager();
        tm.begin();
        AssertJUnit.assertTrue((boolean)c1.getAdvancedCache().lock((Object[])new MagicKey[]{local}));
        Exceptions.expectException(AvailabilityException.class, () -> c0.getAdvancedCache().lock((Object[])new MagicKey[]{remote}));
        Exceptions.expectException(AvailabilityException.class, () -> c1.getAdvancedCache().lock((Object[])new MagicKey[]{remote}));
        tm.rollback();
    }

    public void testLockWhenSplitThenMerge() throws Exception {
        Cache c0 = this.cache(0);
        MagicKey key1 = new MagicKey("key1", this.cache(1), this.cache(2));
        MagicKey key2 = new MagicKey("key2", this.cache(2), this.cache(0));
        c0.put((Object)key1, (Object)"value");
        c0.put((Object)key2, (Object)"value");
        this.splitCluster({0, 1}, {2, 3});
        this.partition(0).assertDegradedMode();
        TransactionManager tm = c0.getAdvancedCache().getTransactionManager();
        tm.begin();
        Exceptions.expectException(AvailabilityException.class, () -> c0.getAdvancedCache().lock((Object[])new MagicKey[]{key1}));
        Exceptions.expectException(AvailabilityException.class, () -> c0.getAdvancedCache().lock((Object[])new MagicKey[]{key2}));
        tm.rollback();
        this.mergeCluster();
        tm.begin();
        AssertJUnit.assertTrue((boolean)c0.getAdvancedCache().lock((Object[])new MagicKey[]{key1}));
        tm.rollback();
    }

    void mergeCluster() {
        this.partition(0).merge(this.partition(1));
        TestingUtil.waitForNoRebalance(this.caches());
        for (int i = 0; i < this.numMembersInCluster; ++i) {
            PartitionHandlingManager phmI = this.partitionHandlingManager(this.cache(i));
            this.eventuallyEquals(AvailabilityMode.AVAILABLE, () -> ((PartitionHandlingManager)phmI).getAvailabilityMode());
        }
    }

    @Override
    protected void customizeCacheConfiguration(ConfigurationBuilder dcc) {
        dcc.transaction().lockingMode(this.lockingMode).cacheStopTimeout(0L).locking().lockAcquisitionTimeout(TestingUtil.shortTimeoutMillis());
    }

    @Override
    protected ConfigurationBuilder cacheConfiguration() {
        return LockPartitionHandlingTest.getDefaultClusteredCacheConfig(this.cacheMode, this.transactional);
    }

    @Override
    public Object[] factory() {
        return Stream.of(PartitionHandling.values()).filter(ph -> ph != PartitionHandling.ALLOW_READ_WRITES).map(ph -> new LockPartitionHandlingTest().partitionHandling((PartitionHandling)ph)).toArray();
    }
}

