/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener.cluster;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="notifications.cachelistener.cluster.ClusterListenerLocalTest")
public class ClusterListenerLocalTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.createCacheManager(new ConfigurationBuilder());
    }

    public void testInsertEvent() {
        Cache cache0 = this.cache();
        ClusterListener clusterListener = new ClusterListener();
        cache0.addListener((Object)clusterListener);
        this.cache.put((Object)1, (Object)"v1");
        this.verifySimpleInsertionEvents(clusterListener, 1, "v1");
    }

    protected void verifySimpleInsertionEvents(ClusterListener listener, Object key, Object expectedValue) {
        Assert.assertEquals((int)listener.events.size(), (int)1);
        CacheEntryEvent event = listener.events.get(0);
        Assert.assertEquals((Object)Event.Type.CACHE_ENTRY_CREATED, (Object)event.getType());
        Assert.assertEquals((Object)key, (Object)event.getKey());
        Assert.assertEquals((Object)expectedValue, (Object)event.getValue());
    }

    @Listener(clustered=true)
    protected static class ClusterListener {
        List<CacheEntryEvent> events = Collections.synchronizedList(new ArrayList());

        protected ClusterListener() {
        }

        @CacheEntryCreated
        @CacheEntryModified
        @CacheEntryRemoved
        public void onCacheEvent(CacheEntryEvent event) {
            log.debugf("Adding new cluster event %s", (Object)event);
            this.events.add(event);
        }
    }
}

