/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.Cache;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.distribution.MagicKey;
import org.infinispan.jmx.AbstractClusterMBeanTest;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcManagerImpl;
import org.infinispan.remoting.transport.MockTransport;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.test.TestingUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jmx.RpcManagerMBeanTest")
public class RpcManagerMBeanTest
extends AbstractClusterMBeanTest {
    public RpcManagerMBeanTest() {
        super(RpcManagerMBeanTest.class.getSimpleName());
    }

    public void testJmxOperationMetadata() throws Exception {
        ObjectName rpcManager = TestingUtil.getCacheObjectName(this.jmxDomain1, this.getDefaultCacheName() + "(repl_sync)", "RpcManager");
        TestingUtil.checkMBeanOperationParameterNaming(this.mBeanServerLookup.getMBeanServer(), rpcManager);
    }

    public void testEnableJmxStats() throws Exception {
        Cache cache1 = this.manager(0).getCache();
        Cache cache2 = this.manager(1).getCache();
        MBeanServer mBeanServer = this.mBeanServerLookup.getMBeanServer();
        ObjectName rpcManager1 = TestingUtil.getCacheObjectName(this.jmxDomain1, this.getDefaultCacheName() + "(repl_sync)", "RpcManager");
        ObjectName rpcManager2 = TestingUtil.getCacheObjectName(this.jmxDomain2, this.getDefaultCacheName() + "(repl_sync)", "RpcManager");
        assert (mBeanServer.isRegistered(rpcManager1));
        assert (mBeanServer.isRegistered(rpcManager2));
        Object statsEnabled = mBeanServer.getAttribute(rpcManager1, "StatisticsEnabled");
        assert (statsEnabled != null);
        Assert.assertEquals((Object)statsEnabled, (Object)Boolean.TRUE);
        Assert.assertEquals((Object)mBeanServer.getAttribute(rpcManager1, "StatisticsEnabled"), (Object)Boolean.TRUE);
        Assert.assertEquals((Object)mBeanServer.getAttribute(rpcManager2, "StatisticsEnabled"), (Object)Boolean.TRUE);
        long initialReplicationCount1 = (Long)mBeanServer.getAttribute(rpcManager1, "ReplicationCount");
        cache1.put((Object)"key", (Object)"value2");
        Assert.assertEquals((String)((String)cache2.get((Object)"key")), (String)"value2");
        Assert.assertEquals((Object)mBeanServer.getAttribute(rpcManager1, "ReplicationCount"), (Object)(initialReplicationCount1 + 1L));
        Assert.assertEquals((Object)mBeanServer.getAttribute(rpcManager1, "ReplicationFailures"), (Object)0L);
        mBeanServer.invoke(rpcManager1, "resetStatistics", new Object[0], new String[0]);
        Assert.assertEquals((Object)mBeanServer.getAttribute(rpcManager1, "ReplicationCount"), (Object)0L);
        Assert.assertEquals((Object)mBeanServer.getAttribute(rpcManager1, "ReplicationFailures"), (Object)0L);
        mBeanServer.setAttribute(rpcManager1, new Attribute("StatisticsEnabled", Boolean.FALSE));
        cache1.put((Object)"key", (Object)"value");
        Assert.assertEquals((String)((String)cache2.get((Object)"key")), (String)"value");
        Assert.assertEquals((Object)mBeanServer.getAttribute(rpcManager1, "ReplicationCount"), (Object)-1L);
        Assert.assertEquals((Object)mBeanServer.getAttribute(rpcManager1, "ReplicationFailures"), (Object)-1L);
        mBeanServer.setAttribute(rpcManager1, new Attribute("StatisticsEnabled", Boolean.TRUE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dependsOnMethods={"testEnableJmxStats"})
    public void testSuccessRatio() throws Exception {
        Cache cache1 = this.manager(0).getCache();
        Cache cache2 = this.manager(1).getCache();
        MBeanServer mBeanServer = this.mBeanServerLookup.getMBeanServer();
        ObjectName rpcManager1 = TestingUtil.getCacheObjectName(this.jmxDomain1, this.getDefaultCacheName() + "(repl_sync)", "RpcManager");
        Assert.assertEquals((Object)mBeanServer.getAttribute(rpcManager1, "ReplicationCount"), (Object)0L);
        Assert.assertEquals((Object)mBeanServer.getAttribute(rpcManager1, "ReplicationFailures"), (Object)0L);
        Assert.assertEquals((Object)mBeanServer.getAttribute(rpcManager1, "SuccessRatio"), (Object)"N/A");
        RpcManagerImpl rpcManager = (RpcManagerImpl)TestingUtil.extractComponent(cache1, RpcManager.class);
        Transport originalTransport = rpcManager.getTransport();
        try {
            MockTransport transport = new MockTransport(this.address(0));
            transport.init(originalTransport.getViewId(), originalTransport.getMembers());
            rpcManager.setTransport((Transport)transport);
            CompletableFuture put1 = cache1.putAsync((Object)new MagicKey("a1", cache1), (Object)"b1");
            this.timeService.advance(50L);
            transport.expectCommand(SingleRpcCommand.class).singleResponse(this.address(2), (Response)SuccessfulResponse.SUCCESSFUL_EMPTY_RESPONSE);
            put1.get(10L, TimeUnit.SECONDS);
            CompletableFuture put2 = cache1.putAsync((Object)new MagicKey("a2", cache2), (Object)"b2");
            this.timeService.advance(10L);
            transport.expectCommand(SingleRpcCommand.class).singleResponse(this.address(2), (Response)SuccessfulResponse.SUCCESSFUL_EMPTY_RESPONSE);
            put2.get(10L, TimeUnit.SECONDS);
            Assert.assertEquals((Object)mBeanServer.getAttribute(rpcManager1, "ReplicationCount"), (Object)2L);
            Assert.assertEquals((Object)mBeanServer.getAttribute(rpcManager1, "SuccessRatio"), (Object)"100%");
            long avgReplTime = (Long)mBeanServer.getAttribute(rpcManager1, "AverageReplicationTime");
            Assert.assertEquals((long)avgReplTime, (long)30L);
            CompletableFuture put3 = cache1.putAsync((Object)new MagicKey("a3", cache1), (Object)"b3");
            transport.expectCommand(SingleRpcCommand.class).throwException(new RuntimeException());
            Exceptions.expectCompletionException(CacheException.class, (CompletionStage)put3);
            CompletableFuture put4 = cache1.putAsync((Object)new MagicKey("a4", cache2), (Object)"b4");
            transport.expectCommand(SingleRpcCommand.class).throwException(new RuntimeException());
            Exceptions.expectCompletionException(CacheException.class, (CompletionStage)put4);
            Assert.assertEquals((Object)mBeanServer.getAttribute(rpcManager1, "SuccessRatio"), (Object)"50%");
        }
        finally {
            rpcManager.setTransport(originalTransport);
        }
    }
}

