/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.IndexedJGroupsAddress;
import org.infinispan.distribution.ch.impl.DefaultConsistentHash;
import org.infinispan.distribution.ch.impl.OwnershipStatistics;
import org.infinispan.distribution.ch.impl.SyncConsistentHashFactory;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.AbstractInfinispanTest;
import org.jgroups.util.UUID;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="distribution.ch.SyncConsistentHashFactoryKeyDistributionTest", groups={"profiling"})
public class SyncConsistentHashFactoryKeyDistributionTest
extends AbstractInfinispanTest {
    public static final int[] NUM_NODES = new int[]{11, 22};
    public static final int[] NUM_SEGMENTS = new int[]{200, 1000};
    public static final int NUM_OWNERS = 2;
    public static final int LOOPS = 1000;
    public static final double[] INTERVALS = new double[]{0.8, 0.9, 1.1, 1.2};
    public static final double[] INTERVALS_PRIMARY = new double[]{0.8, 0.9, 1.1, 1.2};
    public static final double[] PERCENTILES = new double[]{0.999};

    protected ConsistentHashFactory<DefaultConsistentHash> createFactory() {
        return new SyncConsistentHashFactory();
    }

    protected List<Address> createAddresses(int numNodes) {
        ArrayList<Address> addresses = new ArrayList<Address>(numNodes);
        for (int i = 0; i < numNodes; ++i) {
            addresses.add(this.createSingleAddress(i));
        }
        return addresses;
    }

    public void testDistribution() {
        for (int nn : NUM_NODES) {
            TreeMap<String, Map<Integer, String>> metrics = new TreeMap<String, Map<Integer, String>>();
            for (int ns : NUM_SEGMENTS) {
                Map<String, String> iterationMetrics = this.computeMetrics(ns, 2, nn);
                iterationMetrics.forEach((metricName, metricValue) -> {
                    Map metric = metrics.computeIfAbsent((String)metricName, k -> new HashMap());
                    metric.put(ns, metricValue);
                });
            }
            this.printMetrics(nn, metrics);
        }
    }

    public void testRebalanceDistribution() {
        for (int nn : NUM_NODES) {
            TreeMap<String, Map<Integer, String>> metrics = new TreeMap<String, Map<Integer, String>>();
            for (int ns : NUM_SEGMENTS) {
                Map<String, String> iterationMetrics = this.computeMetricsAfterRebalance(ns, 2, nn);
                iterationMetrics.forEach((metricName, metricValue) -> {
                    Map metric = metrics.computeIfAbsent((String)metricName, k -> new HashMap());
                    metric.put(ns, metricValue);
                });
            }
            this.printMetrics(nn, metrics);
        }
    }

    protected void printMetrics(int nn, Map<String, Map<Integer, String>> metrics) {
        System.out.printf("Distribution for %3d nodes (relative to the average)\n===\n", nn);
        System.out.printf("%35s = ", "Segments");
        for (int numSegment : NUM_SEGMENTS) {
            System.out.printf("%7d", numSegment);
        }
        System.out.println();
        Object object = metrics.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            String metricName = (String)entry.getKey();
            Map metricValues = (Map)entry.getValue();
            System.out.printf("%35s = ", metricName);
            for (int numSegment : NUM_SEGMENTS) {
                System.out.print((String)metricValues.get(numSegment));
            }
            System.out.println();
        }
        System.out.println();
    }

    protected Map<String, String> computeMetrics(int numSegments, int numOwners, int numNodes) {
        List<Address> members = this.createAddresses(numNodes);
        HashMap<String, String> metrics = new HashMap<String, String>();
        long[] distribution = new long[1000 * numNodes];
        long[] distributionPrimary = new long[1000 * numNodes];
        double[] largestRatio = new double[1000];
        int distIndex = 0;
        ConsistentHashFactory<DefaultConsistentHash> chf = this.createFactory();
        for (int i = 0; i < 1000; ++i) {
            DefaultConsistentHash ch = (DefaultConsistentHash)chf.create(numOwners, numSegments, members, null);
            OwnershipStatistics stats = new OwnershipStatistics((ConsistentHash)ch, ch.getMembers());
            AssertJUnit.assertEquals((int)(numSegments * numOwners), (int)stats.sumOwned());
            for (Address node : ch.getMembers()) {
                distribution[distIndex] = stats.getOwned(node);
                distributionPrimary[distIndex] = stats.getPrimaryOwned(node);
                ++distIndex;
            }
            largestRatio[i] = this.getSegmentsPerNodesMinMaxRatio(ch);
        }
        Arrays.sort(distribution);
        Arrays.sort(distributionPrimary);
        Arrays.sort(largestRatio);
        this.addMetrics(metrics, "Any owner:", numSegments, numOwners, numNodes, distribution, INTERVALS);
        this.addMetrics(metrics, "Primary:", numSegments, 1, numNodes, distributionPrimary, INTERVALS_PRIMARY);
        this.addDoubleMetric(metrics, "Segments per node - max/min ratio", largestRatio[largestRatio.length - 1]);
        return metrics;
    }

    protected Map<String, String> computeMetricsAfterRebalance(int numSegments, int numOwners, int numNodes) {
        List<Address> members = this.createAddresses(numNodes);
        HashMap<String, String> metrics = new HashMap<String, String>();
        long[] distribution = new long[1000 * numNodes];
        long[] distributionPrimary = new long[1000 * numNodes];
        double[] largestRatio = new double[1000];
        int distIndex = 0;
        ConsistentHashFactory<DefaultConsistentHash> chf = this.createFactory();
        DefaultConsistentHash ch = (DefaultConsistentHash)chf.create(numOwners, numSegments, members, null);
        for (int i = 0; i < 1000; ++i) {
            members.remove(0);
            DefaultConsistentHash rebalancedCH = (DefaultConsistentHash)chf.updateMembers((ConsistentHash)ch, members, null);
            ch = (DefaultConsistentHash)chf.rebalance((ConsistentHash)rebalancedCH);
            Address joiner = this.createSingleAddress(numNodes + i);
            members.add(joiner);
            rebalancedCH = (DefaultConsistentHash)chf.updateMembers((ConsistentHash)ch, members, null);
            ch = (DefaultConsistentHash)chf.rebalance((ConsistentHash)rebalancedCH);
            OwnershipStatistics stats = new OwnershipStatistics((ConsistentHash)ch, ch.getMembers());
            AssertJUnit.assertEquals((int)(numSegments * numOwners), (int)stats.sumOwned());
            for (Address node : ch.getMembers()) {
                distribution[distIndex] = stats.getOwned(node);
                distributionPrimary[distIndex] = stats.getPrimaryOwned(node);
                ++distIndex;
            }
            largestRatio[i] = this.getSegmentsPerNodesMinMaxRatio(ch);
        }
        Arrays.sort(distribution);
        Arrays.sort(distributionPrimary);
        Arrays.sort(largestRatio);
        this.addMetrics(metrics, "Any owner:", numSegments, numOwners, numNodes, distribution, INTERVALS);
        this.addMetrics(metrics, "Primary:", numSegments, 1, numNodes, distributionPrimary, INTERVALS_PRIMARY);
        this.addDoubleMetric(metrics, "Segments per node - max/min ratio", largestRatio[largestRatio.length - 1]);
        return metrics;
    }

    protected void addMetrics(Map<String, String> metrics, String prefix, int numSegments, int numOwners, int numNodes, long[] distribution, double[] intervals) {
        int i;
        int i2;
        long sum = 0L;
        for (long x : distribution) {
            sum += x;
        }
        AssertJUnit.assertEquals((long)sum, (long)(1000 * numOwners * numSegments));
        double mean = (double)sum / (double)numNodes / 1000.0;
        long min = distribution[0];
        long max = distribution[distribution.length - 1];
        this.addDoubleMetric(metrics, prefix + " min", (double)min / mean);
        this.addDoubleMetric(metrics, prefix + " max", (double)max / mean);
        double[] intervalProbability = new double[intervals.length];
        int intervalIndex = 0;
        for (i2 = 0; i2 < distribution.length; ++i2) {
            long x = distribution[i2];
            while ((double)x > intervals[intervalIndex] * mean) {
                intervalProbability[intervalIndex] = (double)i2 / (double)distribution.length;
                if (++intervalIndex < intervals.length) continue;
            }
        }
        for (i2 = intervalIndex; i2 < intervals.length; ++i2) {
            intervalProbability[i2] = 1.0;
        }
        for (i2 = 0; i2 < intervals.length; ++i2) {
            if (intervals[i2] < 1.0) {
                this.addPercentageMetric(metrics, String.format("%s %% < %3.2f", prefix, intervals[i2]), intervalProbability[i2]);
                continue;
            }
            this.addPercentageMetric(metrics, String.format("%s %% > %3.2f", prefix, intervals[i2]), 1.0 - intervalProbability[i2]);
        }
        double[] percentiles = new double[PERCENTILES.length];
        for (i = 0; i < PERCENTILES.length; ++i) {
            percentiles[i] = (double)distribution[(int)Math.ceil(PERCENTILES[i] * (double)(1000 * numNodes + 1))] / mean;
        }
        for (i = 0; i < PERCENTILES.length; ++i) {
            this.addDoubleMetric(metrics, String.format("%s %5.2f%% percentile", prefix, PERCENTILES[i] * 100.0), percentiles[i]);
        }
    }

    protected void addDoubleMetric(Map<String, String> metrics, String name, double value) {
        metrics.put(name, String.format("%7.3f", value));
    }

    protected void addPercentageMetric(Map<String, String> metrics, String name, double value) {
        metrics.put(name, String.format("%6.2f%%", value * 100.0));
    }

    protected Address createSingleAddress(int nodeIndex) {
        return new IndexedJGroupsAddress((org.jgroups.Address)UUID.randomUUID(), nodeIndex);
    }

    protected double getSegmentsPerNodesMinMaxRatio(DefaultConsistentHash ch) {
        int max = 0;
        int min = Integer.MAX_VALUE;
        for (Address addr : ch.getMembers()) {
            int num = ch.getSegmentsForOwner(addr).size();
            max = Math.max(max, num);
            min = Math.min(min, num);
        }
        double d = (double)max / (double)min;
        return d;
    }
}

