/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import java.util.Map;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.impl.OwnershipStatistics;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unstable"}, testName="distribution.ch.CapacityFactorsFunctionalTest", description="to be fixed by ISPN-6470")
public class CapacityFactorsFunctionalTest
extends MultipleCacheManagersTest {
    public static final int NUM_SEGMENTS = 60;

    @Override
    protected void createCacheManagers() throws Throwable {
    }

    public void testCapacityFactors() {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.clustering().cacheMode(CacheMode.DIST_SYNC);
        cb.clustering().hash().numSegments(60);
        cb.clustering().hash().capacityFactor(0.5f);
        this.addClusterEnabledCacheManager(cb);
        this.waitForClusterToForm();
        this.assertCapacityFactors(0.5f);
        this.assertPrimaryOwned(60);
        this.assertOwned(60);
        cb.clustering().hash().capacityFactor(1.5f);
        this.addClusterEnabledCacheManager(cb);
        this.waitForClusterToForm();
        this.assertCapacityFactors(0.5f, 1.5f);
        this.assertPrimaryOwned(15, 45);
        this.assertOwned(60, 60);
        cb.clustering().hash().capacityFactor(0.0f);
        this.addClusterEnabledCacheManager(cb);
        this.waitForClusterToForm();
        this.assertCapacityFactors(0.5f, 1.5f, 0.0f);
        this.assertPrimaryOwned(15, 45, 0);
        this.assertOwned(60, 60, 0);
        cb.clustering().hash().capacityFactor(1.0f);
        this.addClusterEnabledCacheManager(cb);
        this.waitForClusterToForm();
        this.assertCapacityFactors(0.5f, 1.5f, 0.0f, 1.0f);
        this.assertPrimaryOwned(10, 30, 0, 20);
        this.assertOwned(20, 60, 0, 40);
    }

    private void assertCapacityFactors(float ... expectedCapacityFactors) {
        ConsistentHash ch = this.cache(0).getAdvancedCache().getDistributionManager().getReadConsistentHash();
        int numNodes = expectedCapacityFactors.length;
        Map capacityFactors = ch.getCapacityFactors();
        for (int i = 0; i < numNodes; ++i) {
            AssertJUnit.assertEquals((double)expectedCapacityFactors[i], (double)((Float)capacityFactors.get(this.address(i))).floatValue(), (double)0.0);
        }
    }

    private void assertPrimaryOwned(int ... expectedPrimaryOwned) {
        ConsistentHash ch = this.cache(0).getAdvancedCache().getDistributionManager().getReadConsistentHash();
        OwnershipStatistics stats = new OwnershipStatistics(ch, ch.getMembers());
        int numNodes = expectedPrimaryOwned.length;
        for (int i = 0; i < numNodes; ++i) {
            double delta = (double)expectedPrimaryOwned[i] * 0.15;
            TestingUtil.assertBetween((double)expectedPrimaryOwned[i] - 2.0 * delta, (double)expectedPrimaryOwned[i] + delta, (double)stats.getPrimaryOwned(this.address(i)));
        }
    }

    private void assertOwned(int ... expectedOwned) {
        ConsistentHash ch = this.cache(0).getAdvancedCache().getDistributionManager().getReadConsistentHash();
        OwnershipStatistics stats = new OwnershipStatistics(ch, ch.getMembers());
        int numNodes = expectedOwned.length;
        for (int i = 0; i < numNodes; ++i) {
            double delta = (double)expectedOwned[i] * 0.25;
            TestingUtil.assertBetween((double)expectedOwned[i] - 2.0 * delta, (double)expectedOwned[i] + delta, (double)stats.getOwned(this.address(i)));
        }
    }
}

