/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands;

import java.lang.invoke.CallSite;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IsolationLevel;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="commands.GetAllCommandTest")
public class GetAllCommandTest
extends MultipleCacheManagersTest {
    private final int numNodes = 4;
    private final int numEntries = 100;

    @Override
    public Object[] factory() {
        return new Object[]{new GetAllCommandTest().transactional(false).cacheMode(CacheMode.DIST_SYNC), new GetAllCommandTest().transactional(false).cacheMode(CacheMode.REPL_SYNC), new GetAllCommandTest().transactional(true).cacheMode(CacheMode.DIST_SYNC), new GetAllCommandTest().transactional(true).cacheMode(CacheMode.REPL_SYNC)};
    }

    @Override
    protected String parameters() {
        return "[" + String.valueOf(this.cacheMode) + ", tx=" + this.transactional + "]";
    }

    public void testGetAllKeyNotPresent() {
        for (int i = 0; i < 100; ++i) {
            this.advancedCache(i % 4).put((Object)("key" + i), (Object)("value" + i));
        }
        List caches = this.caches();
        String notPresentString = "not-present";
        for (Cache cache : caches) {
            Map result = cache.getAdvancedCache().getAll(Collections.singleton(notPresentString));
            Assert.assertFalse((boolean)result.containsKey(notPresentString));
            Assert.assertNull(result.get(notPresentString));
        }
    }

    public void testGetAllCacheEntriesKeyNotPresent() {
        for (int i = 0; i < 100; ++i) {
            this.advancedCache(i % 4).put((Object)("key" + i), (Object)("value" + i));
        }
        List caches = this.caches();
        String notPresentString = "not-present";
        for (Cache cache : caches) {
            Map result = cache.getAdvancedCache().getAllCacheEntries(Collections.singleton(notPresentString));
            Assert.assertFalse((boolean)result.containsKey(notPresentString));
            Assert.assertNull(result.get(notPresentString));
        }
    }

    public void testGetAllCacheEntriesWithBytes() {
        HashSet<CallSite> keys = new HashSet<CallSite>();
        for (int i = 0; i < 100; ++i) {
            String key = "key" + i;
            this.advancedCache(i % 4).put((Object)key, (Object)new byte[]{(byte)i});
            keys.add((CallSite)((Object)key));
        }
        List caches = this.caches();
        for (Cache cache : caches) {
            Map map = cache.getAdvancedCache().getAllCacheEntries(keys);
            Assert.assertEquals((int)map.size(), (int)keys.size());
            for (int i = 0; i < 100; ++i) {
                CacheEntry entry = (CacheEntry)map.get("key" + i);
                Assert.assertEquals((int)((byte[])entry.getValue()).length, (int)1);
                Assert.assertEquals((int)((byte[])entry.getValue())[0], (int)i);
            }
        }
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder dcc = GetAllCommandTest.getDefaultClusteredCacheConfig(this.cacheMode, this.transactional);
        if (this.transactional.booleanValue()) {
            dcc.transaction().locking().isolationLevel(IsolationLevel.READ_COMMITTED);
        }
        this.createCluster(dcc, 4);
        this.waitForClusterToForm();
    }

    public void testGetAll() {
        int i;
        for (i = 0; i < 100; ++i) {
            this.advancedCache(i % 4).put((Object)("key" + i), (Object)("value" + i));
        }
        for (i = 0; i < 100; ++i) {
            for (Cache cache : this.caches()) {
                Assert.assertEquals((Object)cache.get((Object)("key" + i)), (Object)("value" + i));
            }
        }
        for (int j = 0; j < 10; ++j) {
            HashSet<CallSite> mutableKeys = new HashSet<CallSite>();
            HashMap<CallSite, CallSite> expected = new HashMap<CallSite, CallSite>();
            for (int i2 = j; i2 < 100; i2 += 10) {
                mutableKeys.add((CallSite)((Object)("key" + i2)));
                expected.put((CallSite)((Object)("key" + i2)), (CallSite)((Object)("value" + i2)));
            }
            Set immutableKeys = Set.copyOf(mutableKeys);
            for (Cache cache : this.caches()) {
                Map result = cache.getAdvancedCache().getAll(immutableKeys);
                Assert.assertEquals((Object)result, expected);
            }
        }
    }

    public void testGetAllCacheEntries() {
        int i;
        for (i = 0; i < 100; ++i) {
            this.advancedCache(i % 4).put((Object)("key" + i), (Object)("value" + i));
        }
        for (i = 0; i < 100; ++i) {
            for (Cache cache : this.caches()) {
                Assert.assertEquals((Object)cache.get((Object)("key" + i)), (Object)("value" + i));
            }
        }
        for (int j = 0; j < 10; ++j) {
            HashSet<CallSite> mutableKeys = new HashSet<CallSite>();
            HashMap<Object, Object> expected = new HashMap<Object, Object>();
            for (int i2 = j; i2 < 100; i2 += 10) {
                mutableKeys.add((CallSite)((Object)("key" + i2)));
                expected.put("key" + i2, "value" + i2);
            }
            Set immutableKeys = Set.copyOf(mutableKeys);
            for (Cache cache : this.caches()) {
                Map result = cache.getAdvancedCache().getAllCacheEntries(immutableKeys);
                expected.forEach((k, v) -> {
                    CacheEntry value = (CacheEntry)result.get(k);
                    Assert.assertNotNull((Object)value);
                    Assert.assertEquals((Object)k, (Object)value.getKey());
                    Assert.assertEquals((Object)v, (Object)value.getValue());
                });
            }
        }
    }
}

