/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api;

import jakarta.transaction.Transaction;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IsolationLevel;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.ReplaceWithValueChangedTest")
public class ReplaceWithValueChangedTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = ReplaceWithValueChangedTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        builder.locking().isolationLevel(IsolationLevel.READ_COMMITTED);
        this.createClusteredCaches(2, TestDataSCI.INSTANCE, builder);
    }

    public void testReplace1() throws Throwable {
        Object k1 = this.getKeyForCache(0);
        this.cache(0).put(k1, (Object)"v1");
        this.tm(0).begin();
        Assert.assertEquals((Object)"v1", (Object)this.cache(0).replace(k1, (Object)"v2"));
        Transaction suspendedTx = this.tm(0).suspend();
        this.cache(0).remove(k1);
        Assert.assertNull((Object)this.cache(0).get(k1));
        Assert.assertNull((Object)this.cache(1).get(k1));
        log.trace((Object)"Here it begins");
        suspendedTx.commit();
        Assert.assertEquals((Object)"v2", (Object)this.cache(0).get(k1));
        Assert.assertEquals((Object)"v2", (Object)this.cache(1).get(k1));
    }

    public void testReplace2() throws Throwable {
        Object k1 = this.getKeyForCache(0);
        this.cache(0).put(k1, (Object)"v1");
        this.tm(0).begin();
        Assert.assertEquals((Object)"v1", (Object)this.cache(0).replace(k1, (Object)"v2"));
        Transaction suspendedTx = this.tm(0).suspend();
        this.cache(0).put(k1, (Object)"v3");
        Assert.assertEquals((Object)this.cache(0).get(k1), (Object)"v3");
        Assert.assertEquals((Object)this.cache(1).get(k1), (Object)"v3");
        suspendedTx.commit();
        Assert.assertEquals((Object)"v2", (Object)this.cache(0).get(k1));
        Assert.assertEquals((Object)"v2", (Object)this.cache(1).get(k1));
    }

    public void testPutIfAbsent() throws Throwable {
        Object k1 = this.getKeyForCache(0);
        this.tm(0).begin();
        Assert.assertNull((Object)this.cache(0).putIfAbsent(k1, (Object)"v1"));
        Transaction suspendedTx = this.tm(0).suspend();
        this.cache(0).put(k1, (Object)"v2");
        Assert.assertEquals((Object)this.cache(0).get(k1), (Object)"v2");
        Assert.assertEquals((Object)this.cache(1).get(k1), (Object)"v2");
        suspendedTx.commit();
        Assert.assertEquals((Object)"v1", (Object)this.cache(0).get(k1));
        Assert.assertEquals((Object)"v1", (Object)this.cache(1).get(k1));
    }

    public void testConditionalRemove() throws Throwable {
        Object k1 = this.getKeyForCache(0);
        this.cache(0).put(k1, (Object)"v1");
        this.tm(0).begin();
        Assert.assertTrue((boolean)this.cache(0).remove(k1, (Object)"v1"));
        Transaction suspendedTx = this.tm(0).suspend();
        this.cache(0).put(k1, (Object)"v2");
        Assert.assertEquals((Object)this.cache(0).get(k1), (Object)"v2");
        Assert.assertEquals((Object)this.cache(1).get(k1), (Object)"v2");
        log.trace((Object)"here it is");
        suspendedTx.commit();
        Assert.assertNull((Object)this.cache(0).get(k1));
        Assert.assertNull((Object)this.cache(1).get(k1));
    }
}

