/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.distribution.DistributionTestHelper;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;
import org.testng.internal.junit.ArrayAsserts;

@Test(groups={"functional"}, testName="api.MetadataAPIDistTest")
public class MetadataAPIDistTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = MetadataAPIDistTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC);
        builder.clustering().hash().numOwners(1);
        this.createCluster(builder, 2);
        this.waitForClusterToForm();
    }

    public void testGetCacheEntryNonOwner() {
        byte[] key = new byte[]{1, 2, 3};
        Cache owner = DistributionTestHelper.getFirstOwner(key, this.caches());
        Cache nonOwner = DistributionTestHelper.getFirstNonOwner(key, this.caches());
        owner.put((Object)key, (Object)new byte[]{4, 5, 6});
        ArrayAsserts.assertArrayEquals((byte[])new byte[]{4, 5, 6}, (byte[])((byte[])owner.get((Object)key)));
        CacheEntry cacheEntry = nonOwner.getAdvancedCache().getCacheEntry((Object)key);
        AssertJUnit.assertNotNull((Object)cacheEntry);
        ArrayAsserts.assertArrayEquals((byte[])new byte[]{4, 5, 6}, (byte[])((byte[])cacheEntry.getValue()));
    }
}

