/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.statetransfer.failures;

import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.Cache;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.BackupConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.MagicKey;
import org.infinispan.remoting.inboundhandler.AbstractDelegatingHandler;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.PerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.test.TestingUtil;
import org.infinispan.xsite.BackupReceiver;
import org.infinispan.xsite.BackupReceiverDelegator;
import org.infinispan.xsite.statetransfer.XSiteState;
import org.infinispan.xsite.statetransfer.XSiteStateConsumer;
import org.infinispan.xsite.statetransfer.XSiteStatePushCommand;
import org.infinispan.xsite.statetransfer.failures.AbstractTopologyChangeTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"xsite"}, testName="xsite.statetransfer.failures.RetryMechanismTest")
public class RetryMechanismTest
extends AbstractTopologyChangeTest {
    private static final String VALUE = "value";

    public void testExceptionWithSuccessfulRetry() {
        this.takeSiteOffline();
        MagicKey key = new MagicKey(this.cache("NYC-2", 1));
        FailureHandler handler = FailureHandler.replaceOn(this.cache("NYC-2", 1));
        CounterBackupReceiver counterRepository = RetryMechanismTest.replaceBackupReceiverOn(this.cache("NYC-2", 0));
        this.cache("LON-1", 0).put((Object)key, (Object)VALUE);
        handler.fail();
        this.startStateTransfer();
        this.assertOnline("LON-1", "NYC-2");
        this.awaitXSiteStateSent("LON-1");
        this.assertEventuallyNoStateTransferInReceivingSite(null);
        AssertJUnit.assertEquals((int)0, (int)handler.remainingFails());
        AssertJUnit.assertEquals((int)1, (int)counterRepository.counter.get());
        this.assertInSite("NYC-2", cache -> AssertJUnit.assertEquals((Object)VALUE, (Object)cache.get(key)));
    }

    public void testExceptionWithFailedRetry() {
        this.takeSiteOffline();
        MagicKey key = new MagicKey(this.cache("NYC-2", 1));
        FailureHandler handler = FailureHandler.replaceOn(this.cache("NYC-2", 1));
        CounterBackupReceiver counterRepository = RetryMechanismTest.replaceBackupReceiverOn(this.cache("NYC-2", 0));
        this.cache("LON-1", 0).put((Object)key, (Object)VALUE);
        handler.failAlways();
        this.startStateTransfer();
        this.assertOnline("LON-1", "NYC-2");
        this.awaitXSiteStateSent("LON-1");
        this.assertEventuallyNoStateTransferInReceivingSite(null);
        this.assertXSiteErrorStatus();
        AssertJUnit.assertEquals((int)3, (int)counterRepository.counter.get());
        this.assertInSite("NYC-2", cache -> AssertJUnit.assertNull((Object)cache.get(key)));
    }

    public void testRetryLocally() throws ExecutionException, InterruptedException {
        this.takeSiteOffline();
        MagicKey key = new MagicKey(this.cache("NYC-2", 1));
        DiscardHandler handler = DiscardHandler.replaceOn(this.cache("NYC-2", 1));
        CounterBackupReceiver counterRepository = RetryMechanismTest.replaceBackupReceiverOn(this.cache("NYC-2", 0));
        this.cache("LON-1", 0).put((Object)key, (Object)VALUE);
        this.startStateTransfer();
        this.assertOnline("LON-1", "NYC-2");
        RetryMechanismTest.eventually(() -> handler.discarded);
        this.triggerTopologyChange("NYC-2", 1).get();
        this.awaitXSiteStateSent("LON-1");
        this.assertEventuallyNoStateTransferInReceivingSite(null);
        AssertJUnit.assertEquals((int)1, (int)counterRepository.counter.get());
        this.assertInSite("NYC-2", cache -> AssertJUnit.assertEquals((Object)VALUE, (Object)cache.get(key)));
    }

    public void testMultipleRetryLocally() throws ExecutionException, InterruptedException {
        this.takeSiteOffline();
        MagicKey key = new MagicKey(this.cache("NYC-2", 1));
        DiscardHandler handler = DiscardHandler.replaceOn(this.cache("NYC-2", 1));
        FailureXSiteConsumer failureXSiteConsumer = FailureXSiteConsumer.replaceOn(this.cache("NYC-2", 0));
        CounterBackupReceiver counterRepository = RetryMechanismTest.replaceBackupReceiverOn(this.cache("NYC-2", 0));
        failureXSiteConsumer.fail();
        this.cache("LON-1", 0).put((Object)key, (Object)VALUE);
        this.startStateTransfer();
        this.assertOnline("LON-1", "NYC-2");
        RetryMechanismTest.eventually(() -> handler.discarded);
        this.triggerTopologyChange("NYC-2", 1).get();
        this.awaitXSiteStateSent("LON-1");
        this.assertEventuallyNoStateTransferInReceivingSite(null);
        AssertJUnit.assertEquals((int)0, (int)failureXSiteConsumer.remainingFails());
        AssertJUnit.assertEquals((int)1, (int)counterRepository.counter.get());
        this.assertInSite("NYC-2", cache -> AssertJUnit.assertEquals((Object)VALUE, (Object)cache.get(key)));
    }

    public void testFailRetryLocally() throws ExecutionException, InterruptedException {
        this.takeSiteOffline();
        MagicKey key = new MagicKey(this.cache("NYC-2", 1));
        DiscardHandler handler = DiscardHandler.replaceOn(this.cache("NYC-2", 1));
        FailureXSiteConsumer failureXSiteConsumer = FailureXSiteConsumer.replaceOn(this.cache("NYC-2", 0));
        CounterBackupReceiver counterRepository = RetryMechanismTest.replaceBackupReceiverOn(this.cache("NYC-2", 0));
        failureXSiteConsumer.failAlways();
        this.cache("LON-1", 0).put((Object)key, (Object)VALUE);
        this.startStateTransfer();
        this.assertOnline("LON-1", "NYC-2");
        RetryMechanismTest.eventually(() -> handler.discarded);
        this.triggerTopologyChange("NYC-2", 1).get();
        this.awaitXSiteStateSent("LON-1");
        this.assertEventuallyNoStateTransferInReceivingSite(null);
        if ("ERROR".equals(this.getXSitePushStatus())) {
            AssertJUnit.assertEquals((int)3, (int)counterRepository.counter.get());
            this.assertInSite("NYC-2", cache -> AssertJUnit.assertNull((Object)cache.get(key)));
        } else {
            AssertJUnit.assertEquals((int)2, (int)counterRepository.counter.get());
            this.assertInSite("NYC-2", cache -> AssertJUnit.assertEquals((Object)VALUE, (Object)cache.get(key)));
        }
    }

    @Override
    protected void adaptLONConfiguration(BackupConfigurationBuilder builder) {
        super.adaptLONConfiguration(builder);
        builder.stateTransfer().maxRetries(2).waitTime(1000L);
        builder.clustering().hash().numSegments(8);
    }

    @Override
    protected ConfigurationBuilder getNycActiveConfig() {
        ConfigurationBuilder builder = super.getNycActiveConfig();
        builder.clustering().hash().numSegments(8);
        return builder;
    }

    private static CounterBackupReceiver replaceBackupReceiverOn(Cache<?, ?> cache) {
        return TestingUtil.wrapComponent(cache, BackupReceiver.class, CounterBackupReceiver::new);
    }

    private static class FailureHandler
    extends AbstractDelegatingHandler {
        static final int FAIL_FOR_EVER = -1;
        private int nFailures = 0;

        private FailureHandler(PerCacheInboundInvocationHandler delegate) {
            super(delegate);
        }

        static FailureHandler replaceOn(Cache<?, ?> cache) {
            return TestingUtil.wrapInboundInvocationHandler(cache, FailureHandler::new);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fail() {
            FailureHandler failureHandler = this;
            synchronized (failureHandler) {
                this.nFailures = 3;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void failAlways() {
            FailureHandler failureHandler = this;
            synchronized (failureHandler) {
                this.nFailures = -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int remainingFails() {
            FailureHandler failureHandler = this;
            synchronized (failureHandler) {
                return this.nFailures;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized boolean beforeHandle(CacheRpcCommand command, Reply reply, DeliverOrder order) {
            if (command instanceof XSiteStatePushCommand) {
                boolean fail;
                FailureHandler failureHandler = this;
                synchronized (failureHandler) {
                    boolean bl = fail = this.nFailures == -1;
                    if (this.nFailures > 0) {
                        fail = true;
                        --this.nFailures;
                    }
                }
                if (fail) {
                    reply.reply((Response)new ExceptionResponse((Exception)((Object)new CacheException("Induced Fail."))));
                    return false;
                }
            }
            return true;
        }
    }

    private static class CounterBackupReceiver
    extends BackupReceiverDelegator {
        private final AtomicInteger counter = new AtomicInteger();

        CounterBackupReceiver(BackupReceiver delegate) {
            super(delegate);
        }

        @Override
        public CompletionStage<Void> handleStateTransferState(XSiteState[] chunk, long timeoutMs) {
            this.counter.getAndIncrement();
            return super.handleStateTransferState(chunk, timeoutMs);
        }
    }

    private static class DiscardHandler
    extends AbstractDelegatingHandler {
        private volatile boolean discarded = false;

        private DiscardHandler(PerCacheInboundInvocationHandler delegate) {
            super(delegate);
        }

        static DiscardHandler replaceOn(Cache<?, ?> cache) {
            return TestingUtil.wrapInboundInvocationHandler(cache, DiscardHandler::new);
        }

        protected boolean beforeHandle(CacheRpcCommand command, Reply reply, DeliverOrder order) {
            if (!this.discarded) {
                this.discarded = command instanceof XSiteStatePushCommand;
            }
            return !this.discarded;
        }
    }

    private static class FailureXSiteConsumer
    implements XSiteStateConsumer {
        static final int FAIL_FOR_EVER = -1;
        private final XSiteStateConsumer delegate;
        private int nFailures = 0;

        private FailureXSiteConsumer(XSiteStateConsumer delegate) {
            this.delegate = delegate;
        }

        public void startStateTransfer(String sendingSite) {
            this.delegate.startStateTransfer(sendingSite);
        }

        public void endStateTransfer(String sendingSite) {
            this.delegate.endStateTransfer(sendingSite);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void applyState(XSiteState[] chunk) throws Exception {
            boolean fail;
            FailureXSiteConsumer failureXSiteConsumer = this;
            synchronized (failureXSiteConsumer) {
                boolean bl = fail = this.nFailures == -1;
                if (this.nFailures > 0) {
                    fail = true;
                    --this.nFailures;
                }
            }
            if (fail) {
                throw new CacheException("Induced Fail");
            }
            this.delegate.applyState(chunk);
        }

        public String getSendingSiteName() {
            return this.delegate.getSendingSiteName();
        }

        static FailureXSiteConsumer replaceOn(Cache<?, ?> cache) {
            return TestingUtil.wrapComponent(cache, XSiteStateConsumer.class, (wrapOn, current) -> new FailureXSiteConsumer((XSiteStateConsumer)current), true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fail() {
            FailureXSiteConsumer failureXSiteConsumer = this;
            synchronized (failureXSiteConsumer) {
                this.nFailures = 3;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void failAlways() {
            FailureXSiteConsumer failureXSiteConsumer = this;
            synchronized (failureXSiteConsumer) {
                this.nFailures = -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int remainingFails() {
            FailureXSiteConsumer failureXSiteConsumer = this;
            synchronized (failureXSiteConsumer) {
                return this.nFailures;
            }
        }
    }
}

