/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.locking;

import jakarta.transaction.NotSupportedException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.TimeoutException;
import org.infinispan.commons.test.ExceptionRunnable;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.MagicKey;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TransportFlags;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.ControlledConsistentHashFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@CleanupAfterMethod
@Test(groups={"functional"}, testName="tx.locking.PrimaryOwnerChangePessimistTxTest")
public class PrimaryOwnerChangePessimistTxTest
extends MultipleCacheManagersTest {
    private ControlledConsistentHashFactory.Default factory;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.factory = new ControlledConsistentHashFactory.Default(new int[][]{{0, 1}, {0, 2}});
        this.createClusteredCaches(3, TestDataSCI.INSTANCE, this.configuration(), new TransportFlags().withFD(true), new String[0]);
    }

    private ConfigurationBuilder configuration() {
        ConfigurationBuilder cb = PrimaryOwnerChangePessimistTxTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        cb.transaction().lockingMode(LockingMode.PESSIMISTIC);
        cb.clustering().hash().numSegments(2).consistentHashFactory((ConsistentHashFactory)this.factory);
        return cb;
    }

    public void testNodeLeaving() throws Exception {
        this.testPrimaryChange(this::nodeLeaves);
    }

    public void testNodeJoining() throws Exception {
        this.testPrimaryChange(this::nodeJoins);
    }

    private void testPrimaryChange(ExceptionRunnable topologyChange) throws Exception {
        MagicKey backupKey = new MagicKey(this.cache(0), this.cache(1));
        MagicKey nonOwnerKey = new MagicKey(this.cache(0), this.cache(2));
        this.assertPrimaryOwner(backupKey, 0);
        this.tm(0).begin();
        this.cache(0).put((Object)backupKey, (Object)"value-0");
        Transaction tx0 = this.tm(0).suspend();
        this.tm(0).begin();
        this.advancedCache(0).lock(new Object[]{nonOwnerKey});
        Transaction tx1 = this.tm(0).suspend();
        this.assertLocked(0, (Object)backupKey);
        this.assertLocked(0, (Object)nonOwnerKey);
        this.factory.setOwnerIndexes(new int[][]{{1, 0}, {1, 0}});
        topologyChange.run();
        this.assertPrimaryOwner(backupKey, 1);
        this.assertPrimaryOwner(nonOwnerKey, 1);
        AdvancedCache zeroTimeoutCache1 = this.advancedCache(1).withFlags(Flag.ZERO_LOCK_ACQUISITION_TIMEOUT);
        this.assertPutTimeout(backupKey, (AdvancedCache<Object, Object>)zeroTimeoutCache1);
        this.assertLockTimeout(backupKey, (AdvancedCache<Object, Object>)zeroTimeoutCache1);
        this.assertPutTimeout(nonOwnerKey, (AdvancedCache<Object, Object>)zeroTimeoutCache1);
        this.assertLockTimeout(nonOwnerKey, (AdvancedCache<Object, Object>)zeroTimeoutCache1);
        this.tm(0).resume(tx0);
        this.tm(0).commit();
        this.tm(0).resume(tx1);
        this.tm(0).commit();
        AssertJUnit.assertEquals((Object)"value-0", (Object)this.cache(0).get((Object)backupKey));
        AssertJUnit.assertEquals((Object)"value-0", (Object)this.cache(1).get((Object)backupKey));
        AssertJUnit.assertNull((Object)this.cache(0).get((Object)nonOwnerKey));
        AssertJUnit.assertNull((Object)this.cache(1).get((Object)nonOwnerKey));
    }

    private void nodeLeaves() {
        this.killMember(2);
    }

    private void nodeJoins() {
        this.addClusterEnabledCacheManager(this.configuration(), new TransportFlags().withFD(true));
        this.waitForClusterToForm();
    }

    private void assertPutTimeout(MagicKey lockedKey1, AdvancedCache<Object, Object> zeroTimeoutCache) throws NotSupportedException, SystemException {
        this.tm(1).begin();
        Exceptions.expectException(TimeoutException.class, () -> zeroTimeoutCache.put((Object)lockedKey1, (Object)"value-1"));
        this.tm(1).rollback();
    }

    private void assertLockTimeout(MagicKey lockedKey1, AdvancedCache<Object, Object> zeroTimeoutCache) throws NotSupportedException, SystemException {
        this.tm(1).begin();
        Exceptions.expectException(TimeoutException.class, () -> zeroTimeoutCache.lock(new Object[]{lockedKey1}));
        this.tm(1).rollback();
    }

    private void assertPrimaryOwner(MagicKey key, int index) {
        DistributionManager dm = this.cache(index).getAdvancedCache().getDistributionManager();
        AssertJUnit.assertTrue((boolean)dm.getCacheTopology().getDistribution((Object)key).isPrimary());
    }
}

