/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.rpc;

import java.util.Map;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.remoting.RemoteException;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.CustomReplicableCommand;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.impl.MapResponseCollector;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="remoting.rpc.RpcManagerCustomReplicableCommandTest", groups={"functional"})
public class RpcManagerCustomReplicableCommandTest
extends MultipleCacheManagersTest {
    protected static final String TEST_CACHE = "testCache";
    protected static final String EXPECTED_RETURN_VALUE = "the-return-value";

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = RpcManagerCustomReplicableCommandTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, true);
        this.createClusteredCaches(2, TEST_CACHE, builder);
    }

    protected ReplicableCommand createReplicableCommandForTest(Object arg) {
        return new CustomReplicableCommand(arg);
    }

    public void testInvokeRemotely() {
        RpcManager rpcManager = this.cache(0, TEST_CACHE).getAdvancedCache().getRpcManager();
        ReplicableCommand command = this.createReplicableCommandForTest(EXPECTED_RETURN_VALUE);
        Map<Address, Response> remoteResponses = this.invoke(rpcManager, command);
        log.tracef("Responses were: %s", remoteResponses);
        AssertJUnit.assertEquals((int)1, (int)remoteResponses.size());
        Response response = remoteResponses.values().iterator().next();
        AssertJUnit.assertNotNull((Object)response);
        AssertJUnit.assertTrue((boolean)response.isValid());
        AssertJUnit.assertTrue((boolean)response.isSuccessful());
        AssertJUnit.assertTrue((boolean)(response instanceof SuccessfulResponse));
        Object value = ((SuccessfulResponse)response).getResponseValue();
        AssertJUnit.assertEquals((Object)EXPECTED_RETURN_VALUE, (Object)value);
    }

    public void testInvokeRemotelyWithRemoteException() {
        RpcManager rpcManager = this.cache(0, TEST_CACHE).getAdvancedCache().getRpcManager();
        ReplicableCommand command = this.createReplicableCommandForTest(new IllegalArgumentException("exception!"));
        try {
            this.invoke(rpcManager, command);
            AssertJUnit.fail((String)"Expected RemoteException not thrown");
        }
        catch (RemoteException e) {
            AssertJUnit.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
            AssertJUnit.assertEquals((String)"exception!", (String)e.getCause().getMessage());
        }
        catch (Exception ex) {
            AssertJUnit.fail((String)("Expected exception not thrown but instead we got : " + String.valueOf(ex)));
        }
    }

    public void testInvokeRemotelyWithResponseMode() {
        RpcManager rpcManager = this.cache(0, TEST_CACHE).getAdvancedCache().getRpcManager();
        ReplicableCommand command = this.createReplicableCommandForTest(EXPECTED_RETURN_VALUE);
        Map<Address, Response> remoteResponses = this.invoke(rpcManager, command);
        log.tracef("Responses were: %s", remoteResponses);
        AssertJUnit.assertEquals((int)1, (int)remoteResponses.size());
        Response response = remoteResponses.values().iterator().next();
        AssertJUnit.assertNotNull((Object)response);
        AssertJUnit.assertTrue((boolean)response.isValid());
        AssertJUnit.assertTrue((boolean)response.isSuccessful());
        AssertJUnit.assertTrue((boolean)(response instanceof SuccessfulResponse));
        Object value = ((SuccessfulResponse)response).getResponseValue();
        AssertJUnit.assertEquals((Object)EXPECTED_RETURN_VALUE, (Object)value);
    }

    public void testInvokeRemotelyWithResponseModeWithRemoteException() {
        RpcManager rpcManager = this.cache(0, TEST_CACHE).getAdvancedCache().getRpcManager();
        ReplicableCommand command = this.createReplicableCommandForTest(new IllegalArgumentException("exception!"));
        try {
            this.invoke(rpcManager, command);
            AssertJUnit.fail((String)"Expected RemoteException not thrown");
        }
        catch (RemoteException e) {
            AssertJUnit.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
            AssertJUnit.assertEquals((String)"exception!", (String)e.getCause().getMessage());
        }
        catch (Exception ex) {
            AssertJUnit.fail((String)("Expected exception not thrown but instead we got : " + String.valueOf(ex)));
        }
    }

    private Map<Address, Response> invoke(RpcManager rpcManager, ReplicableCommand command) {
        return (Map)rpcManager.blocking(rpcManager.invokeCommandOnAll(command, (ResponseCollector)MapResponseCollector.ignoreLeavers(), rpcManager.getSyncRpcOptions()));
    }
}

