/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.time.ControlledTimeService;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(testName="persistence.IgnoreModificationsStoreTest", groups={"functional"}, sequential=true)
@CleanupAfterMethod
public class IgnoreModificationsStoreTest
extends SingleCacheManagerTest {
    private static final long EXPIRATION_TIME = 1000000L;
    DummyInMemoryStore store;
    ControlledTimeService timeService = new ControlledTimeService();
    boolean expiration;

    IgnoreModificationsStoreTest expiration(boolean expiration) {
        this.expiration = expiration;
        return this;
    }

    @Factory
    public Object[] factory() {
        return new Object[]{new IgnoreModificationsStoreTest().expiration(false), new IgnoreModificationsStoreTest().expiration(true)};
    }

    @Override
    protected String parameters() {
        return "[" + this.expiration + "]";
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(false);
        if (this.expiration) {
            cfg.expiration().lifespan(1000000L, TimeUnit.MILLISECONDS);
        }
        ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)cfg.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).segmented(false)).storeName(IgnoreModificationsStoreTest.class.getName()).ignoreModifications(true);
        EmbeddedCacheManager ecm = TestCacheManagerFactory.createCacheManager(cfg);
        TestingUtil.replaceComponent((CacheContainer)ecm, TimeService.class, this.timeService, true);
        return ecm;
    }

    @Override
    protected void setup() throws Exception {
        super.setup();
        this.store = (DummyInMemoryStore)TestingUtil.getFirstStore(this.cache);
    }

    public void testReadOnlyCacheStore() throws PersistenceException, IOException, InterruptedException {
        String storeDataName = IgnoreModificationsStoreTest.class.getName() + "_" + this.cache.getName();
        Map<Object, byte[]> storeMap = DummyInMemoryStore.getStoreDataForName(storeDataName).get(0);
        DummyInMemoryStore dummyInMemoryStore = (DummyInMemoryStore)TestingUtil.getFirstStoreWait(this.cache).delegate();
        byte[] storedBytes = dummyInMemoryStore.valueToStoredBytes("v1");
        storeMap.put("k1", storedBytes);
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.get((Object)"k1"));
        TestingUtil.writeToAllStores("k2", "v2", this.cache);
        AssertJUnit.assertTrue((boolean)this.store.contains("k1"));
        AssertJUnit.assertFalse((boolean)this.store.contains("k2"));
        this.cache.put((Object)"k2", (Object)"v2");
        AssertJUnit.assertEquals((Object)"v2", (Object)this.cache.get((Object)"k2"));
        AssertJUnit.assertTrue((boolean)this.store.contains("k1"));
        AssertJUnit.assertFalse((boolean)this.store.contains("k2"));
        AssertJUnit.assertFalse((boolean)TestingUtil.deleteFromAllStores("k1", this.cache));
        AssertJUnit.assertFalse((boolean)TestingUtil.deleteFromAllStores("k2", this.cache));
        AssertJUnit.assertFalse((boolean)TestingUtil.deleteFromAllStores("k3", this.cache));
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.get((Object)"k1"));
        AssertJUnit.assertEquals((Object)"v2", (Object)this.cache.get((Object)"k2"));
        this.cache.remove((Object)"k1");
        this.cache.remove((Object)"k2");
        AssertJUnit.assertNotNull((Object)this.cache.get((Object)"k1"));
        AssertJUnit.assertNull((Object)this.cache.get((Object)"k2"));
        if (this.expiration) {
            dummyInMemoryStore = (DummyInMemoryStore)TestingUtil.getFirstStoreWait(this.cache).delegate();
            storedBytes = dummyInMemoryStore.valueToStoredBytes("v1-new");
            storeMap.put("k1", storedBytes);
            AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.get((Object)"k1"));
            this.timeService.advance(1000001L);
            AssertJUnit.assertEquals((Object)"v1-new", (Object)this.cache.get((Object)"k1"));
        }
    }
}

