/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachemanagerlistener;

import java.util.Collections;
import java.util.List;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerListener;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifierImpl;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStartedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStoppedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.Event;
import org.infinispan.notifications.cachemanagerlistener.event.SitesViewChangedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.AbstractInfinispanTest;
import org.mockito.Mockito;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="notifications.cachemanagerlistener.CacheManagerNotifierImplTest")
public class CacheManagerNotifierImplTest
extends AbstractInfinispanTest {
    CacheManagerNotifierImpl n;
    CacheManagerListener cl;

    @BeforeMethod
    public void setUp() {
        this.n = new CacheManagerNotifierImpl();
        this.cl = new CacheManagerListener();
        this.n.start();
        this.n.addListener((Object)this.cl);
    }

    public void testNotifyViewChanged() {
        Address a = (Address)Mockito.mock(Address.class);
        List addresses = Collections.emptyList();
        this.n.notifyViewChange(addresses, addresses, a, 100);
        ViewChangedEvent event = this.assertSingleEvent(ViewChangedEvent.class, Event.Type.VIEW_CHANGED);
        AssertJUnit.assertSame((Object)a, (Object)event.getLocalAddress());
        AssertJUnit.assertSame(addresses, (Object)event.getNewMembers());
        AssertJUnit.assertEquals((int)100, (int)event.getViewId());
    }

    public void testNotifyCacheStarted() {
        this.n.notifyCacheStarted("cache");
        CacheStartedEvent event = this.assertSingleEvent(CacheStartedEvent.class, Event.Type.CACHE_STARTED);
        AssertJUnit.assertEquals((String)"cache", (String)event.getCacheName());
    }

    public void testNotifyCacheStopped() {
        this.n.notifyCacheStopped("cache");
        CacheStoppedEvent event = this.assertSingleEvent(CacheStoppedEvent.class, Event.Type.CACHE_STOPPED);
        AssertJUnit.assertEquals((String)"cache", (String)event.getCacheName());
    }

    public void testNotifySitesViewChanged() {
        this.n.notifyCrossSiteViewChanged(List.of("a", "b"), List.of("b"), List.of("c"));
        SitesViewChangedEvent event = this.assertSingleEvent(SitesViewChangedEvent.class, Event.Type.SITES_VIEW_CHANGED);
        AssertJUnit.assertEquals(List.of("a", "b"), (Object)event.getSites());
        AssertJUnit.assertEquals(List.of("b"), (Object)event.getJoiners());
        AssertJUnit.assertEquals(List.of("c"), (Object)event.getLeavers());
    }

    private <T extends Event> T assertSingleEvent(Class<T> eventInterface, Event.Type type) {
        AssertJUnit.assertEquals((int)1, (int)this.cl.getInvocationCount());
        AssertJUnit.assertEquals((Object)type, (Object)this.cl.getEvent().getType());
        AssertJUnit.assertTrue((boolean)eventInterface.isInstance(this.cl.getEvent()));
        return (T)((Event)eventInterface.cast(this.cl.getEvent()));
    }
}

